import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import { matchNamePath } from './valueUtil';
/**
 * NameMap like a `Map` but accepts `string[]` as key.
 */

var NameMap = /*#__PURE__*/function () {
  function NameMap() {
    _classCallCheck(this, NameMap);

    this.list = [];
  }

  _createClass(NameMap, [{
    key: "set",
    value: function set(key, value) {
      var index = this.list.findIndex(function (item) {
        return matchNamePath(item.key, key);
      });

      if (index !== -1) {
        this.list[index].value = value;
      } else {
        this.list.push({
          key: key,
          value: value
        });
      }
    }
  }, {
    key: "get",
    value: function get(key) {
      var result = this.list.find(function (item) {
        return matchNamePath(item.key, key);
      });
      return result && result.value;
    }
  }, {
    key: "update",
    value: function update(key, updater) {
      var origin = this.get(key);
      var next = updater(origin);

      if (!next) {
        this.delete(key);
      } else {
        this.set(key, next);
      }
    }
  }, {
    key: "delete",
    value: function _delete(key) {
      this.list = this.list.filter(function (item) {
        return !matchNamePath(item.key, key);
      });
    }
  }, {
    key: "map",
    value: function map(callback) {
      return this.list.map(callback);
    }
  }, {
    key: "toJSON",
    value: function toJSON() {
      var json = {};
      this.map(function (_ref) {
        var key = _ref.key,
            value = _ref.value;
        json[key.join('.')] = value;
        return null;
      });
      return json;
    }
  }]);

  return NameMap;
}();

export default NameMap;