import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import * as React from 'react';
import classNames from 'classnames';
import { scrollTo } from '../../utils/uiUtil';
import PanelContext from '../../PanelContext';

function TimeUnitColumn(props) {
  var prefixCls = props.prefixCls,
      units = props.units,
      onSelect = props.onSelect,
      value = props.value,
      active = props.active,
      hideDisabledOptions = props.hideDisabledOptions;
  var cellPrefixCls = "".concat(prefixCls, "-cell");

  var _React$useContext = React.useContext(PanelContext),
      open = _React$useContext.open;

  var ulRef = React.useRef(null);
  var liRefs = React.useRef(new Map()); // `useLayoutEffect` here to avoid blink by duration is 0

  React.useLayoutEffect(function () {
    var li = liRefs.current.get(value);

    if (li && open !== false) {
      scrollTo(ulRef.current, li.offsetTop, 120);
    }
  }, [value]);
  React.useLayoutEffect(function () {
    if (open) {
      var li = liRefs.current.get(value);

      if (li) {
        scrollTo(ulRef.current, li.offsetTop, 0);
      }
    }
  }, [open]);
  return React.createElement("ul", {
    className: classNames("".concat(prefixCls, "-column"), _defineProperty({}, "".concat(prefixCls, "-column-active"), active)),
    ref: ulRef,
    style: {
      position: 'relative'
    }
  }, units.map(function (unit) {
    var _classNames2;

    if (hideDisabledOptions && unit.disabled) {
      return null;
    }

    return React.createElement("li", {
      key: unit.value,
      ref: function ref(element) {
        liRefs.current.set(unit.value, element);
      },
      className: classNames(cellPrefixCls, (_classNames2 = {}, _defineProperty(_classNames2, "".concat(cellPrefixCls, "-disabled"), unit.disabled), _defineProperty(_classNames2, "".concat(cellPrefixCls, "-selected"), value === unit.value), _classNames2)),
      onClick: function onClick() {
        if (unit.disabled) {
          return;
        }

        onSelect(unit.value);
      }
    }, React.createElement("div", {
      className: "".concat(cellPrefixCls, "-inner")
    }, unit.label));
  }));
}

export default TimeUnitColumn;