"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useLayoutEffect;

var React = _interopRequireWildcard(require("react"));

var _commonUtil = require("../utils/commonUtil");

/* eslint-disable react-hooks/rules-of-hooks */

/**
 * Wrap `React.useLayoutEffect` which will not throw warning message in test env
 */
function useLayoutEffect(effect, deps) {
  // Never happen in test env
  if (_commonUtil.isBrowserClient) {
    /* istanbul ignore next */
    React.useLayoutEffect(effect, deps);
  } else {
    React.useEffect(effect, deps);
  }
}
/* eslint-enable */