import React from 'react';
import { TriggerProps } from 'rc-trigger';
import { AlignType, AnimationType, ActionType } from 'rc-trigger/lib/interface';
export interface TooltipProps extends Pick<TriggerProps, 'onPopupAlign' | 'builtinPlacements'> {
    trigger?: ActionType | ActionType[];
    defaultVisible?: boolean;
    visible?: boolean;
    placement?: string;
    transitionName?: string;
    animation?: AnimationType;
    onVisibleChange?: (visible: boolean) => void;
    afterVisibleChange?: () => void;
    overlay: (() => React.ReactNode) | React.ReactNode;
    overlayStyle?: React.CSSProperties;
    overlayClassName?: string;
    prefixCls?: string;
    mouseEnterDelay?: number;
    mouseLeaveDelay?: number;
    getTooltipContainer?: (node: HTMLElement) => HTMLElement;
    destroyTooltipOnHide?: boolean | {
        keepParent?: boolean;
    };
    align?: AlignType;
    arrowContent?: React.ReactNode;
    id?: string;
    children?: React.ReactElement;
    popupVisible?: boolean;
    overlayInnerStyle?: React.CSSProperties;
}
declare const _default: React.ForwardRefExoticComponent<TooltipProps & React.RefAttributes<unknown>>;
export default _default;
