'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onUnmount = exports.onMount = undefined;
exports._onClick = _onClick;
exports._onKeyDown = _onKeyDown;
exports._shouldConsider = _shouldConsider;

var _dom_helpers = require('./lib/dom_helpers');

var _dom_helpers2 = _interopRequireDefault(_dom_helpers);

var _listeners = require('./lib/listeners');

var _listeners2 = _interopRequireDefault(_listeners);

var _store = require('./store');

var store = _interopRequireWildcard(_store);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /* eslint-disable no-use-before-define */
/**
 * @module eventHandlers
 *
 */


/**
 * private
 *
 */

/**
 * _onClick
 *
 * @access private
 * @param {object} event The click event object
 * @param {object} event.target The DOM node from the click event
 */
function _onClick(_ref) {
  var target = _ref.target;

  store.activate([].concat(_toConsumableArray(store.getInstances())).reduce(_dom_helpers2.default.findContainerNodes(target), []).sort(_dom_helpers2.default.sortByDOMPosition).map(function (item) {
    return item.instance;
  }));
}

/**
 * _onKeyDown: The keydown event callback
 *
 * @access private
 * @param {object} event The keydown event object
 * @param {number} event.which The key code (which) received from the keydown event
 */
function _onKeyDown(event) {
  var forceConsider = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  if (forceConsider || _shouldConsider(event)) {
    var _ref2 = store.findBindingForEvent(event) || {},
        fn = _ref2.fn,
        instance = _ref2.instance;

    if (fn) {
      fn.call(instance, event);
      return true;
    }
  }
  return false;
}

/**
 * _shouldConsider: Conditions for proceeding with key event handling
 *
 * @access private
 * @param {object} event The keydown event object
 * @param {object} event.target The node origin of the event
 * @return {boolean} Whether to continue procesing the keydown event
 */
function _shouldConsider(_ref3) {
  var ctrlKey = _ref3.ctrlKey,
      target = _ref3.target;

  return ctrlKey || !~['INPUT', 'SELECT', 'TEXTAREA'].indexOf(target.tagName) && (!target.getAttribute || target.getAttribute('role') !== 'textbox');
}

/**
 * public
 *
 */

/**
 * onMount
 *
 * @access public
 */
function onMount(instance) {
  store.activate(instance);
  _listeners2.default.bindKeys(_onKeyDown);
  _listeners2.default.bindClicks(_onClick);
  _dom_helpers2.default.bindFocusables(instance, store.activate);
}

/**
 * onUnmount
 *
 * @access public
 */
function onUnmount(instance) {
  store.deleteInstance(instance);
  if (store.isEmpty()) {
    _listeners2.default.unbindClicks(_onClick);
    _listeners2.default.unbindKeys(_onKeyDown);
  }
}

exports.onMount = onMount;
exports.onUnmount = onUnmount;