var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 Uber Technologies, Inc.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
import { createElement } from 'react';
import PropTypes from 'prop-types';
import BaseControl from './base-control';

import { getDynamicPosition, ANCHOR_POSITION } from '../utils/dynamic-position';

var propTypes = Object.assign({}, BaseControl.propTypes, {
  // Custom className
  className: PropTypes.string,
  // Longitude of the anchor point
  longitude: PropTypes.number.isRequired,
  // Latitude of the anchor point
  latitude: PropTypes.number.isRequired,
  // Offset from the left
  offsetLeft: PropTypes.number,
  // Offset from the top
  offsetTop: PropTypes.number,
  // Size of the tip
  tipSize: PropTypes.number,
  // Whether to show close button
  closeButton: PropTypes.bool,
  // Whether to close on click
  closeOnClick: PropTypes.bool,
  // The popup's location relative to the coordinate
  anchor: PropTypes.oneOf(Object.keys(ANCHOR_POSITION)),
  // Whether the popup anchor should be auto-adjusted to fit within the container
  dynamicPosition: PropTypes.bool,
  // Callback when component is closed
  onClose: PropTypes.func
});

var defaultProps = Object.assign({}, BaseControl.defaultProps, {
  className: '',
  offsetLeft: 0,
  offsetTop: 0,
  tipSize: 10,
  anchor: 'bottom',
  dynamicPosition: true,
  closeButton: true,
  closeOnClick: true,
  onClose: function onClose() {}
});

/*
 * PureComponent doesn't update when context changes.
 * The only way is to implement our own shouldComponentUpdate here. Considering
 * the parent component (StaticMap or InteractiveMap) is pure, and map re-render
 * is almost always triggered by a viewport change, we almost definitely need to
 * recalculate the popup's position when the parent re-renders.
 */

var Popup = function (_BaseControl) {
  _inherits(Popup, _BaseControl);

  function Popup(props) {
    _classCallCheck(this, Popup);

    var _this = _possibleConstructorReturn(this, (Popup.__proto__ || Object.getPrototypeOf(Popup)).call(this, props));

    _this._getPosition = _this._getPosition.bind(_this);
    _this._onClose = _this._onClose.bind(_this);
    _this._contentLoaded = _this._contentLoaded.bind(_this);
    _this._renderTip = _this._renderTip.bind(_this);
    _this._renderContent = _this._renderContent.bind(_this);
    return _this;
  }

  _createClass(Popup, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      // Container just got a size, re-calculate position
      this.forceUpdate();
    }
  }, {
    key: '_getPosition',
    value: function _getPosition(x, y) {
      var viewport = this.context.viewport;
      var _props = this.props,
          anchor = _props.anchor,
          dynamicPosition = _props.dynamicPosition,
          tipSize = _props.tipSize;


      if (this._content) {
        return dynamicPosition ? getDynamicPosition({
          x: x, y: y, anchor: anchor,
          padding: tipSize,
          width: viewport.width,
          height: viewport.height,
          selfWidth: this._content.clientWidth,
          selfHeight: this._content.clientHeight
        }) : anchor;
      }

      return anchor;
    }
  }, {
    key: '_onClose',
    value: function _onClose() {
      this.props.onClose();
    }
  }, {
    key: '_contentLoaded',
    value: function _contentLoaded(ref) {
      this._content = ref;
    }
  }, {
    key: '_renderTip',
    value: function _renderTip() {
      var tipSize = this.props.tipSize;


      return createElement('div', {
        key: 'tip',
        className: 'mapboxgl-popup-tip',
        style: { borderWidth: tipSize }
      });
    }
  }, {
    key: '_renderContent',
    value: function _renderContent() {
      var _props2 = this.props,
          closeButton = _props2.closeButton,
          children = _props2.children;

      return createElement('div', {
        key: 'content',
        ref: this._contentLoaded,
        className: 'mapboxgl-popup-content'
      }, [closeButton && createElement('button', {
        key: 'close-button',
        className: 'mapboxgl-popup-close-button',
        type: 'button',
        onClick: this._onClose
      }, '×'), children]);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props3 = this.props,
          className = _props3.className,
          longitude = _props3.longitude,
          latitude = _props3.latitude,
          offsetLeft = _props3.offsetLeft,
          offsetTop = _props3.offsetTop,
          closeOnClick = _props3.closeOnClick;

      var _context$viewport$pro = this.context.viewport.project([longitude, latitude]),
          _context$viewport$pro2 = _slicedToArray(_context$viewport$pro, 2),
          x = _context$viewport$pro2[0],
          y = _context$viewport$pro2[1];

      var positionType = this._getPosition(x, y);
      var anchorPosition = ANCHOR_POSITION[positionType];

      var containerStyle = {
        position: 'absolute',
        left: x + offsetLeft,
        top: y + offsetTop,
        transform: 'translate(' + -anchorPosition.x * 100 + '%, ' + -anchorPosition.y * 100 + '%)'
      };

      return createElement('div', {
        className: 'mapboxgl-popup mapboxgl-popup-anchor-' + positionType + ' ' + className,
        style: containerStyle,
        ref: this._onContainerLoad,
        onClick: closeOnClick ? this._onClose : null
      }, [this._renderTip(), this._renderContent()]);
    }
  }]);

  return Popup;
}(BaseControl);

export default Popup;


Popup.displayName = 'Popup';
Popup.propTypes = propTypes;
Popup.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jb21wb25lbnRzL3BvcHVwLmpzIl0sIm5hbWVzIjpbImNyZWF0ZUVsZW1lbnQiLCJQcm9wVHlwZXMiLCJCYXNlQ29udHJvbCIsImdldER5bmFtaWNQb3NpdGlvbiIsIkFOQ0hPUl9QT1NJVElPTiIsInByb3BUeXBlcyIsIk9iamVjdCIsImFzc2lnbiIsImNsYXNzTmFtZSIsInN0cmluZyIsImxvbmdpdHVkZSIsIm51bWJlciIsImlzUmVxdWlyZWQiLCJsYXRpdHVkZSIsIm9mZnNldExlZnQiLCJvZmZzZXRUb3AiLCJ0aXBTaXplIiwiY2xvc2VCdXR0b24iLCJib29sIiwiY2xvc2VPbkNsaWNrIiwiYW5jaG9yIiwib25lT2YiLCJrZXlzIiwiZHluYW1pY1Bvc2l0aW9uIiwib25DbG9zZSIsImZ1bmMiLCJkZWZhdWx0UHJvcHMiLCJQb3B1cCIsInByb3BzIiwiX2dldFBvc2l0aW9uIiwiYmluZCIsIl9vbkNsb3NlIiwiX2NvbnRlbnRMb2FkZWQiLCJfcmVuZGVyVGlwIiwiX3JlbmRlckNvbnRlbnQiLCJmb3JjZVVwZGF0ZSIsIngiLCJ5Iiwidmlld3BvcnQiLCJjb250ZXh0IiwiX2NvbnRlbnQiLCJwYWRkaW5nIiwid2lkdGgiLCJoZWlnaHQiLCJzZWxmV2lkdGgiLCJjbGllbnRXaWR0aCIsInNlbGZIZWlnaHQiLCJjbGllbnRIZWlnaHQiLCJyZWYiLCJrZXkiLCJzdHlsZSIsImJvcmRlcldpZHRoIiwiY2hpbGRyZW4iLCJ0eXBlIiwib25DbGljayIsInByb2plY3QiLCJwb3NpdGlvblR5cGUiLCJhbmNob3JQb3NpdGlvbiIsImNvbnRhaW5lclN0eWxlIiwicG9zaXRpb24iLCJsZWZ0IiwidG9wIiwidHJhbnNmb3JtIiwiX29uQ29udGFpbmVyTG9hZCIsImRpc3BsYXlOYW1lIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBQUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFRQSxhQUFSLFFBQTRCLE9BQTVCO0FBQ0EsT0FBT0MsU0FBUCxNQUFzQixZQUF0QjtBQUNBLE9BQU9DLFdBQVAsTUFBd0IsZ0JBQXhCOztBQUVBLFNBQVFDLGtCQUFSLEVBQTRCQyxlQUE1QixRQUFrRCwyQkFBbEQ7O0FBRUEsSUFBTUMsWUFBWUMsT0FBT0MsTUFBUCxDQUFjLEVBQWQsRUFBa0JMLFlBQVlHLFNBQTlCLEVBQXlDO0FBQ3pEO0FBQ0FHLGFBQVdQLFVBQVVRLE1BRm9DO0FBR3pEO0FBQ0FDLGFBQVdULFVBQVVVLE1BQVYsQ0FBaUJDLFVBSjZCO0FBS3pEO0FBQ0FDLFlBQVVaLFVBQVVVLE1BQVYsQ0FBaUJDLFVBTjhCO0FBT3pEO0FBQ0FFLGNBQVliLFVBQVVVLE1BUm1DO0FBU3pEO0FBQ0FJLGFBQVdkLFVBQVVVLE1BVm9DO0FBV3pEO0FBQ0FLLFdBQVNmLFVBQVVVLE1BWnNDO0FBYXpEO0FBQ0FNLGVBQWFoQixVQUFVaUIsSUFka0M7QUFlekQ7QUFDQUMsZ0JBQWNsQixVQUFVaUIsSUFoQmlDO0FBaUJ6RDtBQUNBRSxVQUFRbkIsVUFBVW9CLEtBQVYsQ0FBZ0JmLE9BQU9nQixJQUFQLENBQVlsQixlQUFaLENBQWhCLENBbEJpRDtBQW1CekQ7QUFDQW1CLG1CQUFpQnRCLFVBQVVpQixJQXBCOEI7QUFxQnpEO0FBQ0FNLFdBQVN2QixVQUFVd0I7QUF0QnNDLENBQXpDLENBQWxCOztBQXlCQSxJQUFNQyxlQUFlcEIsT0FBT0MsTUFBUCxDQUFjLEVBQWQsRUFBa0JMLFlBQVl3QixZQUE5QixFQUE0QztBQUMvRGxCLGFBQVcsRUFEb0Q7QUFFL0RNLGNBQVksQ0FGbUQ7QUFHL0RDLGFBQVcsQ0FIb0Q7QUFJL0RDLFdBQVMsRUFKc0Q7QUFLL0RJLFVBQVEsUUFMdUQ7QUFNL0RHLG1CQUFpQixJQU44QztBQU8vRE4sZUFBYSxJQVBrRDtBQVEvREUsZ0JBQWMsSUFSaUQ7QUFTL0RLLFdBQVMsbUJBQU0sQ0FBRTtBQVQ4QyxDQUE1QyxDQUFyQjs7QUFZQTs7Ozs7Ozs7SUFPcUJHLEs7OztBQUVuQixpQkFBWUMsS0FBWixFQUFtQjtBQUFBOztBQUFBLDhHQUNYQSxLQURXOztBQUdqQixVQUFLQyxZQUFMLEdBQW9CLE1BQUtBLFlBQUwsQ0FBa0JDLElBQWxCLE9BQXBCO0FBQ0EsVUFBS0MsUUFBTCxHQUFnQixNQUFLQSxRQUFMLENBQWNELElBQWQsT0FBaEI7QUFDQSxVQUFLRSxjQUFMLEdBQXNCLE1BQUtBLGNBQUwsQ0FBb0JGLElBQXBCLE9BQXRCO0FBQ0EsVUFBS0csVUFBTCxHQUFrQixNQUFLQSxVQUFMLENBQWdCSCxJQUFoQixPQUFsQjtBQUNBLFVBQUtJLGNBQUwsR0FBc0IsTUFBS0EsY0FBTCxDQUFvQkosSUFBcEIsT0FBdEI7QUFQaUI7QUFRbEI7Ozs7d0NBRW1CO0FBQ2xCO0FBQ0EsV0FBS0ssV0FBTDtBQUNEOzs7aUNBRVlDLEMsRUFBR0MsQyxFQUFHO0FBQUEsVUFDVkMsUUFEVSxHQUNFLEtBQUtDLE9BRFAsQ0FDVkQsUUFEVTtBQUFBLG1CQUUwQixLQUFLVixLQUYvQjtBQUFBLFVBRVZSLE1BRlUsVUFFVkEsTUFGVTtBQUFBLFVBRUZHLGVBRkUsVUFFRkEsZUFGRTtBQUFBLFVBRWVQLE9BRmYsVUFFZUEsT0FGZjs7O0FBSWpCLFVBQUksS0FBS3dCLFFBQVQsRUFBbUI7QUFDakIsZUFBT2pCLGtCQUFrQnBCLG1CQUFtQjtBQUMxQ2lDLGNBRDBDLEVBQ3ZDQyxJQUR1QyxFQUNwQ2pCLGNBRG9DO0FBRTFDcUIsbUJBQVN6QixPQUZpQztBQUcxQzBCLGlCQUFPSixTQUFTSSxLQUgwQjtBQUkxQ0Msa0JBQVFMLFNBQVNLLE1BSnlCO0FBSzFDQyxxQkFBVyxLQUFLSixRQUFMLENBQWNLLFdBTGlCO0FBTTFDQyxzQkFBWSxLQUFLTixRQUFMLENBQWNPO0FBTmdCLFNBQW5CLENBQWxCLEdBT0YzQixNQVBMO0FBUUQ7O0FBRUQsYUFBT0EsTUFBUDtBQUNEOzs7K0JBRVU7QUFDVCxXQUFLUSxLQUFMLENBQVdKLE9BQVg7QUFDRDs7O21DQUVjd0IsRyxFQUFLO0FBQ2xCLFdBQUtSLFFBQUwsR0FBZ0JRLEdBQWhCO0FBQ0Q7OztpQ0FFWTtBQUFBLFVBQ0poQyxPQURJLEdBQ08sS0FBS1ksS0FEWixDQUNKWixPQURJOzs7QUFHWCxhQUFPaEIsY0FBYyxLQUFkLEVBQXFCO0FBQzFCaUQsYUFBSyxLQURxQjtBQUUxQnpDLG1CQUFXLG9CQUZlO0FBRzFCMEMsZUFBTyxFQUFDQyxhQUFhbkMsT0FBZDtBQUhtQixPQUFyQixDQUFQO0FBS0Q7OztxQ0FFZ0I7QUFBQSxvQkFDaUIsS0FBS1ksS0FEdEI7QUFBQSxVQUNSWCxXQURRLFdBQ1JBLFdBRFE7QUFBQSxVQUNLbUMsUUFETCxXQUNLQSxRQURMOztBQUVmLGFBQU9wRCxjQUFjLEtBQWQsRUFBcUI7QUFDMUJpRCxhQUFLLFNBRHFCO0FBRTFCRCxhQUFLLEtBQUtoQixjQUZnQjtBQUcxQnhCLG1CQUFXO0FBSGUsT0FBckIsRUFJSixDQUNEUyxlQUFlakIsY0FBYyxRQUFkLEVBQXdCO0FBQ3JDaUQsYUFBSyxjQURnQztBQUVyQ3pDLG1CQUFXLDZCQUYwQjtBQUdyQzZDLGNBQU0sUUFIK0I7QUFJckNDLGlCQUFTLEtBQUt2QjtBQUp1QixPQUF4QixFQUtaLEdBTFksQ0FEZCxFQU9EcUIsUUFQQyxDQUpJLENBQVA7QUFhRDs7OzZCQUVRO0FBQUEsb0JBQ3VFLEtBQUt4QixLQUQ1RTtBQUFBLFVBQ0FwQixTQURBLFdBQ0FBLFNBREE7QUFBQSxVQUNXRSxTQURYLFdBQ1dBLFNBRFg7QUFBQSxVQUNzQkcsUUFEdEIsV0FDc0JBLFFBRHRCO0FBQUEsVUFDZ0NDLFVBRGhDLFdBQ2dDQSxVQURoQztBQUFBLFVBQzRDQyxTQUQ1QyxXQUM0Q0EsU0FENUM7QUFBQSxVQUN1REksWUFEdkQsV0FDdURBLFlBRHZEOztBQUFBLGtDQUdRLEtBQUtvQixPQUFMLENBQWFELFFBQWIsQ0FBc0JpQixPQUF0QixDQUE4QixDQUFDN0MsU0FBRCxFQUFZRyxRQUFaLENBQTlCLENBSFI7QUFBQTtBQUFBLFVBR0F1QixDQUhBO0FBQUEsVUFHR0MsQ0FISDs7QUFLUCxVQUFNbUIsZUFBZSxLQUFLM0IsWUFBTCxDQUFrQk8sQ0FBbEIsRUFBcUJDLENBQXJCLENBQXJCO0FBQ0EsVUFBTW9CLGlCQUFpQnJELGdCQUFnQm9ELFlBQWhCLENBQXZCOztBQUVBLFVBQU1FLGlCQUFpQjtBQUNyQkMsa0JBQVUsVUFEVztBQUVyQkMsY0FBTXhCLElBQUl0QixVQUZXO0FBR3JCK0MsYUFBS3hCLElBQUl0QixTQUhZO0FBSXJCK0Msa0NBQXdCLENBQUNMLGVBQWVyQixDQUFoQixHQUFvQixHQUE1QyxXQUFxRCxDQUFDcUIsZUFBZXBCLENBQWhCLEdBQW9CLEdBQXpFO0FBSnFCLE9BQXZCOztBQU9BLGFBQU9yQyxjQUFjLEtBQWQsRUFBcUI7QUFDMUJRLDZEQUFtRGdELFlBQW5ELFNBQW1FaEQsU0FEekM7QUFFMUIwQyxlQUFPUSxjQUZtQjtBQUcxQlYsYUFBSyxLQUFLZSxnQkFIZ0I7QUFJMUJULGlCQUFTbkMsZUFBZSxLQUFLWSxRQUFwQixHQUErQjtBQUpkLE9BQXJCLEVBS0osQ0FDRCxLQUFLRSxVQUFMLEVBREMsRUFFRCxLQUFLQyxjQUFMLEVBRkMsQ0FMSSxDQUFQO0FBU0Q7Ozs7RUE5RmdDaEMsVzs7ZUFBZHlCLEs7OztBQWtHckJBLE1BQU1xQyxXQUFOLEdBQW9CLE9BQXBCO0FBQ0FyQyxNQUFNdEIsU0FBTixHQUFrQkEsU0FBbEI7QUFDQXNCLE1BQU1ELFlBQU4sR0FBcUJBLFlBQXJCIiwiZmlsZSI6InBvcHVwLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSAyMDE1IFViZXIgVGVjaG5vbG9naWVzLCBJbmMuXG5cbi8vIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbi8vIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZG9jdW1lbnRhdGlvbiBmaWxlcyAodGhlIFwiU29mdHdhcmVcIiksIHRvIGRlYWxcbi8vIGluIHRoZSBTb2Z0d2FyZSB3aXRob3V0IHJlc3RyaWN0aW9uLCBpbmNsdWRpbmcgd2l0aG91dCBsaW1pdGF0aW9uIHRoZSByaWdodHNcbi8vIHRvIHVzZSwgY29weSwgbW9kaWZ5LCBtZXJnZSwgcHVibGlzaCwgZGlzdHJpYnV0ZSwgc3VibGljZW5zZSwgYW5kL29yIHNlbGxcbi8vIGNvcGllcyBvZiB0aGUgU29mdHdhcmUsIGFuZCB0byBwZXJtaXQgcGVyc29ucyB0byB3aG9tIHRoZSBTb2Z0d2FyZSBpc1xuLy8gZnVybmlzaGVkIHRvIGRvIHNvLCBzdWJqZWN0IHRvIHRoZSBmb2xsb3dpbmcgY29uZGl0aW9uczpcblxuLy8gVGhlIGFib3ZlIGNvcHlyaWdodCBub3RpY2UgYW5kIHRoaXMgcGVybWlzc2lvbiBub3RpY2Ugc2hhbGwgYmUgaW5jbHVkZWQgaW5cbi8vIGFsbCBjb3BpZXMgb3Igc3Vic3RhbnRpYWwgcG9ydGlvbnMgb2YgdGhlIFNvZnR3YXJlLlxuXG4vLyBUSEUgU09GVFdBUkUgSVMgUFJPVklERUQgXCJBUyBJU1wiLCBXSVRIT1VUIFdBUlJBTlRZIE9GIEFOWSBLSU5ELCBFWFBSRVNTIE9SXG4vLyBJTVBMSUVELCBJTkNMVURJTkcgQlVUIE5PVCBMSU1JVEVEIFRPIFRIRSBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSxcbi8vIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuLy8gQVVUSE9SUyBPUiBDT1BZUklHSFQgSE9MREVSUyBCRSBMSUFCTEUgRk9SIEFOWSBDTEFJTSwgREFNQUdFUyBPUiBPVEhFUlxuLy8gTElBQklMSVRZLCBXSEVUSEVSIElOIEFOIEFDVElPTiBPRiBDT05UUkFDVCwgVE9SVCBPUiBPVEhFUldJU0UsIEFSSVNJTkcgRlJPTSxcbi8vIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbi8vIFRIRSBTT0ZUV0FSRS5cbmltcG9ydCB7Y3JlYXRlRWxlbWVudH0gZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCBCYXNlQ29udHJvbCBmcm9tICcuL2Jhc2UtY29udHJvbCc7XG5cbmltcG9ydCB7Z2V0RHluYW1pY1Bvc2l0aW9uLCBBTkNIT1JfUE9TSVRJT059IGZyb20gJy4uL3V0aWxzL2R5bmFtaWMtcG9zaXRpb24nO1xuXG5jb25zdCBwcm9wVHlwZXMgPSBPYmplY3QuYXNzaWduKHt9LCBCYXNlQ29udHJvbC5wcm9wVHlwZXMsIHtcbiAgLy8gQ3VzdG9tIGNsYXNzTmFtZVxuICBjbGFzc05hbWU6IFByb3BUeXBlcy5zdHJpbmcsXG4gIC8vIExvbmdpdHVkZSBvZiB0aGUgYW5jaG9yIHBvaW50XG4gIGxvbmdpdHVkZTogUHJvcFR5cGVzLm51bWJlci5pc1JlcXVpcmVkLFxuICAvLyBMYXRpdHVkZSBvZiB0aGUgYW5jaG9yIHBvaW50XG4gIGxhdGl0dWRlOiBQcm9wVHlwZXMubnVtYmVyLmlzUmVxdWlyZWQsXG4gIC8vIE9mZnNldCBmcm9tIHRoZSBsZWZ0XG4gIG9mZnNldExlZnQ6IFByb3BUeXBlcy5udW1iZXIsXG4gIC8vIE9mZnNldCBmcm9tIHRoZSB0b3BcbiAgb2Zmc2V0VG9wOiBQcm9wVHlwZXMubnVtYmVyLFxuICAvLyBTaXplIG9mIHRoZSB0aXBcbiAgdGlwU2l6ZTogUHJvcFR5cGVzLm51bWJlcixcbiAgLy8gV2hldGhlciB0byBzaG93IGNsb3NlIGJ1dHRvblxuICBjbG9zZUJ1dHRvbjogUHJvcFR5cGVzLmJvb2wsXG4gIC8vIFdoZXRoZXIgdG8gY2xvc2Ugb24gY2xpY2tcbiAgY2xvc2VPbkNsaWNrOiBQcm9wVHlwZXMuYm9vbCxcbiAgLy8gVGhlIHBvcHVwJ3MgbG9jYXRpb24gcmVsYXRpdmUgdG8gdGhlIGNvb3JkaW5hdGVcbiAgYW5jaG9yOiBQcm9wVHlwZXMub25lT2YoT2JqZWN0LmtleXMoQU5DSE9SX1BPU0lUSU9OKSksXG4gIC8vIFdoZXRoZXIgdGhlIHBvcHVwIGFuY2hvciBzaG91bGQgYmUgYXV0by1hZGp1c3RlZCB0byBmaXQgd2l0aGluIHRoZSBjb250YWluZXJcbiAgZHluYW1pY1Bvc2l0aW9uOiBQcm9wVHlwZXMuYm9vbCxcbiAgLy8gQ2FsbGJhY2sgd2hlbiBjb21wb25lbnQgaXMgY2xvc2VkXG4gIG9uQ2xvc2U6IFByb3BUeXBlcy5mdW5jXG59KTtcblxuY29uc3QgZGVmYXVsdFByb3BzID0gT2JqZWN0LmFzc2lnbih7fSwgQmFzZUNvbnRyb2wuZGVmYXVsdFByb3BzLCB7XG4gIGNsYXNzTmFtZTogJycsXG4gIG9mZnNldExlZnQ6IDAsXG4gIG9mZnNldFRvcDogMCxcbiAgdGlwU2l6ZTogMTAsXG4gIGFuY2hvcjogJ2JvdHRvbScsXG4gIGR5bmFtaWNQb3NpdGlvbjogdHJ1ZSxcbiAgY2xvc2VCdXR0b246IHRydWUsXG4gIGNsb3NlT25DbGljazogdHJ1ZSxcbiAgb25DbG9zZTogKCkgPT4ge31cbn0pO1xuXG4vKlxuICogUHVyZUNvbXBvbmVudCBkb2Vzbid0IHVwZGF0ZSB3aGVuIGNvbnRleHQgY2hhbmdlcy5cbiAqIFRoZSBvbmx5IHdheSBpcyB0byBpbXBsZW1lbnQgb3VyIG93biBzaG91bGRDb21wb25lbnRVcGRhdGUgaGVyZS4gQ29uc2lkZXJpbmdcbiAqIHRoZSBwYXJlbnQgY29tcG9uZW50IChTdGF0aWNNYXAgb3IgSW50ZXJhY3RpdmVNYXApIGlzIHB1cmUsIGFuZCBtYXAgcmUtcmVuZGVyXG4gKiBpcyBhbG1vc3QgYWx3YXlzIHRyaWdnZXJlZCBieSBhIHZpZXdwb3J0IGNoYW5nZSwgd2UgYWxtb3N0IGRlZmluaXRlbHkgbmVlZCB0b1xuICogcmVjYWxjdWxhdGUgdGhlIHBvcHVwJ3MgcG9zaXRpb24gd2hlbiB0aGUgcGFyZW50IHJlLXJlbmRlcnMuXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFBvcHVwIGV4dGVuZHMgQmFzZUNvbnRyb2wge1xuXG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuXG4gICAgdGhpcy5fZ2V0UG9zaXRpb24gPSB0aGlzLl9nZXRQb3NpdGlvbi5iaW5kKHRoaXMpO1xuICAgIHRoaXMuX29uQ2xvc2UgPSB0aGlzLl9vbkNsb3NlLmJpbmQodGhpcyk7XG4gICAgdGhpcy5fY29udGVudExvYWRlZCA9IHRoaXMuX2NvbnRlbnRMb2FkZWQuYmluZCh0aGlzKTtcbiAgICB0aGlzLl9yZW5kZXJUaXAgPSB0aGlzLl9yZW5kZXJUaXAuYmluZCh0aGlzKTtcbiAgICB0aGlzLl9yZW5kZXJDb250ZW50ID0gdGhpcy5fcmVuZGVyQ29udGVudC5iaW5kKHRoaXMpO1xuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgLy8gQ29udGFpbmVyIGp1c3QgZ290IGEgc2l6ZSwgcmUtY2FsY3VsYXRlIHBvc2l0aW9uXG4gICAgdGhpcy5mb3JjZVVwZGF0ZSgpO1xuICB9XG5cbiAgX2dldFBvc2l0aW9uKHgsIHkpIHtcbiAgICBjb25zdCB7dmlld3BvcnR9ID0gdGhpcy5jb250ZXh0O1xuICAgIGNvbnN0IHthbmNob3IsIGR5bmFtaWNQb3NpdGlvbiwgdGlwU2l6ZX0gPSB0aGlzLnByb3BzO1xuXG4gICAgaWYgKHRoaXMuX2NvbnRlbnQpIHtcbiAgICAgIHJldHVybiBkeW5hbWljUG9zaXRpb24gPyBnZXREeW5hbWljUG9zaXRpb24oe1xuICAgICAgICB4LCB5LCBhbmNob3IsXG4gICAgICAgIHBhZGRpbmc6IHRpcFNpemUsXG4gICAgICAgIHdpZHRoOiB2aWV3cG9ydC53aWR0aCxcbiAgICAgICAgaGVpZ2h0OiB2aWV3cG9ydC5oZWlnaHQsXG4gICAgICAgIHNlbGZXaWR0aDogdGhpcy5fY29udGVudC5jbGllbnRXaWR0aCxcbiAgICAgICAgc2VsZkhlaWdodDogdGhpcy5fY29udGVudC5jbGllbnRIZWlnaHRcbiAgICAgIH0pIDogYW5jaG9yO1xuICAgIH1cblxuICAgIHJldHVybiBhbmNob3I7XG4gIH1cblxuICBfb25DbG9zZSgpIHtcbiAgICB0aGlzLnByb3BzLm9uQ2xvc2UoKTtcbiAgfVxuXG4gIF9jb250ZW50TG9hZGVkKHJlZikge1xuICAgIHRoaXMuX2NvbnRlbnQgPSByZWY7XG4gIH1cblxuICBfcmVuZGVyVGlwKCkge1xuICAgIGNvbnN0IHt0aXBTaXplfSA9IHRoaXMucHJvcHM7XG5cbiAgICByZXR1cm4gY3JlYXRlRWxlbWVudCgnZGl2Jywge1xuICAgICAga2V5OiAndGlwJyxcbiAgICAgIGNsYXNzTmFtZTogJ21hcGJveGdsLXBvcHVwLXRpcCcsXG4gICAgICBzdHlsZToge2JvcmRlcldpZHRoOiB0aXBTaXplfVxuICAgIH0pO1xuICB9XG5cbiAgX3JlbmRlckNvbnRlbnQoKSB7XG4gICAgY29uc3Qge2Nsb3NlQnV0dG9uLCBjaGlsZHJlbn0gPSB0aGlzLnByb3BzO1xuICAgIHJldHVybiBjcmVhdGVFbGVtZW50KCdkaXYnLCB7XG4gICAgICBrZXk6ICdjb250ZW50JyxcbiAgICAgIHJlZjogdGhpcy5fY29udGVudExvYWRlZCxcbiAgICAgIGNsYXNzTmFtZTogJ21hcGJveGdsLXBvcHVwLWNvbnRlbnQnXG4gICAgfSwgW1xuICAgICAgY2xvc2VCdXR0b24gJiYgY3JlYXRlRWxlbWVudCgnYnV0dG9uJywge1xuICAgICAgICBrZXk6ICdjbG9zZS1idXR0b24nLFxuICAgICAgICBjbGFzc05hbWU6ICdtYXBib3hnbC1wb3B1cC1jbG9zZS1idXR0b24nLFxuICAgICAgICB0eXBlOiAnYnV0dG9uJyxcbiAgICAgICAgb25DbGljazogdGhpcy5fb25DbG9zZVxuICAgICAgfSwgJ8OXJyksXG4gICAgICBjaGlsZHJlblxuICAgIF0pO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IHtjbGFzc05hbWUsIGxvbmdpdHVkZSwgbGF0aXR1ZGUsIG9mZnNldExlZnQsIG9mZnNldFRvcCwgY2xvc2VPbkNsaWNrfSA9IHRoaXMucHJvcHM7XG5cbiAgICBjb25zdCBbeCwgeV0gPSB0aGlzLmNvbnRleHQudmlld3BvcnQucHJvamVjdChbbG9uZ2l0dWRlLCBsYXRpdHVkZV0pO1xuXG4gICAgY29uc3QgcG9zaXRpb25UeXBlID0gdGhpcy5fZ2V0UG9zaXRpb24oeCwgeSk7XG4gICAgY29uc3QgYW5jaG9yUG9zaXRpb24gPSBBTkNIT1JfUE9TSVRJT05bcG9zaXRpb25UeXBlXTtcblxuICAgIGNvbnN0IGNvbnRhaW5lclN0eWxlID0ge1xuICAgICAgcG9zaXRpb246ICdhYnNvbHV0ZScsXG4gICAgICBsZWZ0OiB4ICsgb2Zmc2V0TGVmdCxcbiAgICAgIHRvcDogeSArIG9mZnNldFRvcCxcbiAgICAgIHRyYW5zZm9ybTogYHRyYW5zbGF0ZSgkey1hbmNob3JQb3NpdGlvbi54ICogMTAwfSUsICR7LWFuY2hvclBvc2l0aW9uLnkgKiAxMDB9JSlgXG4gICAgfTtcblxuICAgIHJldHVybiBjcmVhdGVFbGVtZW50KCdkaXYnLCB7XG4gICAgICBjbGFzc05hbWU6IGBtYXBib3hnbC1wb3B1cCBtYXBib3hnbC1wb3B1cC1hbmNob3ItJHtwb3NpdGlvblR5cGV9ICR7Y2xhc3NOYW1lfWAsXG4gICAgICBzdHlsZTogY29udGFpbmVyU3R5bGUsXG4gICAgICByZWY6IHRoaXMuX29uQ29udGFpbmVyTG9hZCxcbiAgICAgIG9uQ2xpY2s6IGNsb3NlT25DbGljayA/IHRoaXMuX29uQ2xvc2UgOiBudWxsXG4gICAgfSwgW1xuICAgICAgdGhpcy5fcmVuZGVyVGlwKCksXG4gICAgICB0aGlzLl9yZW5kZXJDb250ZW50KClcbiAgICBdKTtcbiAgfVxuXG59XG5cblBvcHVwLmRpc3BsYXlOYW1lID0gJ1BvcHVwJztcblBvcHVwLnByb3BUeXBlcyA9IHByb3BUeXBlcztcblBvcHVwLmRlZmF1bHRQcm9wcyA9IGRlZmF1bHRQcm9wcztcbiJdfQ==