// Copyright (c) 2015 Uber Technologies, Inc.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// React Map Components
export { default } from './components/interactive-map';
export { default as InteractiveMap } from './components/interactive-map';
export { default as StaticMap } from './components/static-map';

// React Controls
export { default as BaseControl } from './components/base-control';
export { default as Marker } from './components/marker';
export { default as Popup } from './components/popup';
export { default as NavigationControl } from './components/navigation-control';

// Overlays
export { default as CanvasOverlay } from './overlays/canvas-overlay';
export { default as HTMLOverlay } from './overlays/html-overlay';
export { default as SVGOverlay } from './overlays/svg-overlay';

export { TRANSITION_EVENTS } from './utils/transition-manager';
export { TransitionInterpolator, LinearInterpolator, ViewportFlyToInterpolator as FlyToInterpolator } from './utils/transition';

// Utilities

// Experimental Features (May change in minor version bumps, use at your own risk)
import MapControls from './utils/map-controls';

export var experimental = {
  MapControls: MapControls
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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