var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 Uber Technologies, Inc.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { createElement } from 'react';
import PropTypes from 'prop-types';
import BaseControl from '../components/base-control';
import { window } from '../utils/globals';

var propTypes = Object.assign({}, BaseControl.propTypes, {
  redraw: PropTypes.func.isRequired
});

var defaultProps = {
  captureScroll: false,
  captureDrag: false,
  captureClick: false,
  captureDoubleClick: false
};

var CanvasOverlay = function (_BaseControl) {
  _inherits(CanvasOverlay, _BaseControl);

  function CanvasOverlay(props) {
    _classCallCheck(this, CanvasOverlay);

    var _this = _possibleConstructorReturn(this, (CanvasOverlay.__proto__ || Object.getPrototypeOf(CanvasOverlay)).call(this, props));

    _this._redraw = _this._redraw.bind(_this);
    _this._canvasLoaded = _this._canvasLoaded.bind(_this);
    return _this;
  }

  _createClass(CanvasOverlay, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._redraw();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      this._redraw();
    }
  }, {
    key: '_redraw',
    value: function _redraw() {
      var pixelRatio = window.devicePixelRatio || 1;
      var canvas = this._canvas;
      var ctx = canvas.getContext('2d');
      ctx.save();
      ctx.scale(pixelRatio, pixelRatio);

      var _context = this.context,
          viewport = _context.viewport,
          isDragging = _context.isDragging;

      this.props.redraw({
        width: viewport.width,
        height: viewport.height,
        ctx: ctx,
        isDragging: isDragging,
        project: viewport.project.bind(viewport),
        unproject: viewport.unproject.bind(viewport)
      });

      ctx.restore();
    }
  }, {
    key: '_canvasLoaded',
    value: function _canvasLoaded(ref) {
      this._canvas = ref;
      this._onContainerLoad(ref);
    }
  }, {
    key: 'render',
    value: function render() {
      var pixelRatio = window.devicePixelRatio || 1;
      var _context$viewport = this.context.viewport,
          width = _context$viewport.width,
          height = _context$viewport.height;


      return createElement('canvas', {
        ref: this._canvasLoaded,
        width: width * pixelRatio,
        height: height * pixelRatio,
        style: {
          width: width + 'px',
          height: height + 'px',
          position: 'absolute',
          pointerEvents: 'none',
          left: 0,
          top: 0
        }
      });
    }
  }]);

  return CanvasOverlay;
}(BaseControl);

export default CanvasOverlay;


CanvasOverlay.displayName = 'CanvasOverlay';
CanvasOverlay.propTypes = propTypes;
CanvasOverlay.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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