var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Copyright (c) 2015 Uber Technologies, Inc.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import MapState from './map-state';
import { LinearInterpolator } from './transition';
import { TRANSITION_EVENTS } from './transition-manager';

var NO_TRANSITION_PROPS = {
  transitionDuration: 0
};
var LINEAR_TRANSITION_PROPS = {
  transitionDuration: 300,
  transitionEasing: function transitionEasing(t) {
    return t;
  },
  transitionInterpolator: new LinearInterpolator(),
  transitionInterruption: TRANSITION_EVENTS.BREAK
};

// EVENT HANDLING PARAMETERS
var PITCH_MOUSE_THRESHOLD = 5;
var PITCH_ACCEL = 1.2;
var ZOOM_ACCEL = 0.01;

var EVENT_TYPES = {
  WHEEL: ['wheel'],
  PAN: ['panstart', 'panmove', 'panend'],
  PINCH: ['pinchstart', 'pinchmove', 'pinchend'],
  DOUBLE_TAP: ['doubletap'],
  KEYBOARD: ['keydown']
};

var MapControls = function () {
  /**
   * @classdesc
   * A class that handles events and updates mercator style viewport parameters
   */
  function MapControls() {
    _classCallCheck(this, MapControls);

    this._state = {
      isDragging: false
    };
    this.events = [];
    this.handleEvent = this.handleEvent.bind(this);
  }

  /**
   * Callback for events
   * @param {hammer.Event} event
   */


  _createClass(MapControls, [{
    key: 'handleEvent',
    value: function handleEvent(event) {
      this.mapState = this.getMapState();

      switch (event.type) {
        case 'panstart':
          return this._onPanStart(event);
        case 'panmove':
          return this._onPan(event);
        case 'panend':
          return this._onPanEnd(event);
        case 'pinchstart':
          return this._onPinchStart(event);
        case 'pinchmove':
          return this._onPinch(event);
        case 'pinchend':
          return this._onPinchEnd(event);
        case 'doubletap':
          return this._onDoubleTap(event);
        case 'wheel':
          return this._onWheel(event);
        case 'keydown':
          return this._onKeyDown(event);
        default:
          return false;
      }
    }

    /* Event utils */
    // Event object: http://hammerjs.github.io/api/#event-object

  }, {
    key: 'getCenter',
    value: function getCenter(event) {
      var _event$offsetCenter = event.offsetCenter,
          x = _event$offsetCenter.x,
          y = _event$offsetCenter.y;

      return [x, y];
    }
  }, {
    key: 'isFunctionKeyPressed',
    value: function isFunctionKeyPressed(event) {
      var srcEvent = event.srcEvent;

      return Boolean(srcEvent.metaKey || srcEvent.altKey || srcEvent.ctrlKey || srcEvent.shiftKey);
    }
  }, {
    key: 'setState',
    value: function setState(newState) {
      Object.assign(this._state, newState);
      if (this.onStateChange) {
        this.onStateChange(this._state);
      }
    }

    /* Callback util */
    // formats map state and invokes callback function

  }, {
    key: 'updateViewport',
    value: function updateViewport(newMapState) {
      var extraProps = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var extraState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      var oldViewport = this.mapState ? this.mapState.getViewportProps() : {};
      var newViewport = Object.assign({}, newMapState.getViewportProps(), extraProps);

      if (this.onViewportChange && Object.keys(newViewport).some(function (key) {
        return oldViewport[key] !== newViewport[key];
      })) {
        // Viewport has changed
        this.onViewportChange(newViewport);
      }

      this.setState(Object.assign({}, newMapState.getInteractiveState(), extraState));
    }
  }, {
    key: 'getMapState',
    value: function getMapState(overrides) {
      return new MapState(Object.assign({}, this.mapStateProps, this._state, overrides));
    }

    /**
     * Extract interactivity options
     */

  }, {
    key: 'setOptions',
    value: function setOptions(options) {
      var onChangeViewport = options.onChangeViewport,
          _options$touchZoomRot = options.touchZoomRotate,
          touchZoomRotate = _options$touchZoomRot === undefined ? true : _options$touchZoomRot,
          onViewportChange = options.onViewportChange,
          _options$onStateChang = options.onStateChange,
          onStateChange = _options$onStateChang === undefined ? this.onStateChange : _options$onStateChang,
          _options$eventManager = options.eventManager,
          eventManager = _options$eventManager === undefined ? this.eventManager : _options$eventManager,
          _options$scrollZoom = options.scrollZoom,
          scrollZoom = _options$scrollZoom === undefined ? true : _options$scrollZoom,
          _options$dragPan = options.dragPan,
          dragPan = _options$dragPan === undefined ? true : _options$dragPan,
          _options$dragRotate = options.dragRotate,
          dragRotate = _options$dragRotate === undefined ? true : _options$dragRotate,
          _options$doubleClickZ = options.doubleClickZoom,
          doubleClickZoom = _options$doubleClickZ === undefined ? true : _options$doubleClickZ,
          _options$touchZoom = options.touchZoom,
          touchZoom = _options$touchZoom === undefined ? true : _options$touchZoom,
          _options$touchRotate = options.touchRotate,
          touchRotate = _options$touchRotate === undefined ? false : _options$touchRotate,
          _options$keyboard = options.keyboard,
          keyboard = _options$keyboard === undefined ? true : _options$keyboard;

      // TODO(deprecate): remove this check when `onChangeViewport` gets deprecated

      this.onViewportChange = onViewportChange || onChangeViewport;
      this.onStateChange = onStateChange;

      if (this.mapStateProps && this.mapStateProps.height !== options.height) {
        // Dimensions changed, normalize the props
        this.updateViewport(new MapState(options));
      }

      this.mapStateProps = options;
      if (this.eventManager !== eventManager) {
        // EventManager has changed
        this.eventManager = eventManager;
        this._events = {};
        this.toggleEvents(this.events, true);
      }
      var isInteractive = Boolean(this.onViewportChange);

      // Register/unregister events
      this.toggleEvents(EVENT_TYPES.WHEEL, isInteractive && scrollZoom);
      this.toggleEvents(EVENT_TYPES.PAN, isInteractive && (dragPan || dragRotate));
      this.toggleEvents(EVENT_TYPES.PINCH, isInteractive && touchZoomRotate);
      this.toggleEvents(EVENT_TYPES.DOUBLE_TAP, isInteractive && doubleClickZoom);
      this.toggleEvents(EVENT_TYPES.KEYBOARD, isInteractive && keyboard);

      // Interaction toggles
      this.scrollZoom = scrollZoom;
      this.dragPan = dragPan;
      this.dragRotate = dragRotate;
      this.doubleClickZoom = doubleClickZoom;
      this.touchZoom = touchZoomRotate && touchZoom;
      this.touchRotate = touchZoomRotate && touchRotate;
      this.keyboard = keyboard;
    }
  }, {
    key: 'toggleEvents',
    value: function toggleEvents(eventNames, enabled) {
      var _this = this;

      if (this.eventManager) {
        eventNames.forEach(function (eventName) {
          if (_this._events[eventName] !== enabled) {
            _this._events[eventName] = enabled;
            if (enabled) {
              _this.eventManager.on(eventName, _this.handleEvent);
            } else {
              _this.eventManager.off(eventName, _this.handleEvent);
            }
          }
        });
      }
    }

    /* Event handlers */
    // Default handler for the `panstart` event.

  }, {
    key: '_onPanStart',
    value: function _onPanStart(event) {
      var pos = this.getCenter(event);
      var newMapState = this.mapState.panStart({ pos: pos }).rotateStart({ pos: pos });
      return this.updateViewport(newMapState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for the `panmove` event.

  }, {
    key: '_onPan',
    value: function _onPan(event) {
      return this.isFunctionKeyPressed(event) || event.rightButton ? this._onPanRotate(event) : this._onPanMove(event);
    }

    // Default handler for the `panend` event.

  }, {
    key: '_onPanEnd',
    value: function _onPanEnd(event) {
      var newMapState = this.mapState.panEnd().rotateEnd();
      return this.updateViewport(newMapState, null, { isDragging: false });
    }

    // Default handler for panning to move.
    // Called by `_onPan` when panning without function key pressed.

  }, {
    key: '_onPanMove',
    value: function _onPanMove(event) {
      if (!this.dragPan) {
        return false;
      }
      var pos = this.getCenter(event);
      var newMapState = this.mapState.pan({ pos: pos });
      return this.updateViewport(newMapState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for panning to rotate.
    // Called by `_onPan` when panning with function key pressed.

  }, {
    key: '_onPanRotate',
    value: function _onPanRotate(event) {
      if (!this.dragRotate) {
        return false;
      }

      var deltaX = event.deltaX,
          deltaY = event.deltaY;

      var _getCenter = this.getCenter(event),
          _getCenter2 = _slicedToArray(_getCenter, 2),
          centerY = _getCenter2[1];

      var startY = centerY - deltaY;

      var _mapState$getViewport = this.mapState.getViewportProps(),
          width = _mapState$getViewport.width,
          height = _mapState$getViewport.height;

      var deltaScaleX = deltaX / width;
      var deltaScaleY = 0;

      if (deltaY > 0) {
        if (Math.abs(height - startY) > PITCH_MOUSE_THRESHOLD) {
          // Move from 0 to -1 as we drag upwards
          deltaScaleY = deltaY / (startY - height) * PITCH_ACCEL;
        }
      } else if (deltaY < 0) {
        if (startY > PITCH_MOUSE_THRESHOLD) {
          // Move from 0 to 1 as we drag upwards
          deltaScaleY = 1 - centerY / startY;
        }
      }
      deltaScaleY = Math.min(1, Math.max(-1, deltaScaleY));

      var newMapState = this.mapState.rotate({ deltaScaleX: deltaScaleX, deltaScaleY: deltaScaleY });
      return this.updateViewport(newMapState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for the `wheel` event.

  }, {
    key: '_onWheel',
    value: function _onWheel(event) {
      if (!this.scrollZoom) {
        return false;
      }

      var pos = this.getCenter(event);
      var delta = event.delta;

      // Map wheel delta to relative scale

      var scale = 2 / (1 + Math.exp(-Math.abs(delta * ZOOM_ACCEL)));
      if (delta < 0 && scale !== 0) {
        scale = 1 / scale;
      }

      var newMapState = this.mapState.zoom({ pos: pos, scale: scale });
      return this.updateViewport(newMapState, NO_TRANSITION_PROPS);
    }

    // Default handler for the `pinchstart` event.

  }, {
    key: '_onPinchStart',
    value: function _onPinchStart(event) {
      var pos = this.getCenter(event);
      var newMapState = this.mapState.zoomStart({ pos: pos }).rotateStart({ pos: pos });
      // hack - hammer's `rotation` field doesn't seem to produce the correct angle
      this._state.startPinchRotation = event.rotation;
      return this.updateViewport(newMapState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for the `pinch` event.

  }, {
    key: '_onPinch',
    value: function _onPinch(event) {
      if (!this.touchZoom && !this.touchRotate) {
        return false;
      }

      var newMapState = this.mapState;
      if (this.touchZoom) {
        var scale = event.scale;

        var pos = this.getCenter(event);
        newMapState = newMapState.zoom({ pos: pos, scale: scale });
      }
      if (this.touchRotate) {
        var rotation = event.rotation;
        var startPinchRotation = this._state.startPinchRotation;

        newMapState = newMapState.rotate({ deltaScaleX: -(rotation - startPinchRotation) / 180 });
      }

      return this.updateViewport(newMapState, NO_TRANSITION_PROPS, { isDragging: true });
    }

    // Default handler for the `pinchend` event.

  }, {
    key: '_onPinchEnd',
    value: function _onPinchEnd(event) {
      var newMapState = this.mapState.zoomEnd().rotateEnd();
      this._state.startPinchRotation = 0;
      return this.updateViewport(newMapState, null, { isDragging: false });
    }

    // Default handler for the `doubletap` event.

  }, {
    key: '_onDoubleTap',
    value: function _onDoubleTap(event) {
      if (!this.doubleClickZoom) {
        return false;
      }
      var pos = this.getCenter(event);
      var isZoomOut = this.isFunctionKeyPressed(event);

      var newMapState = this.mapState.zoom({ pos: pos, scale: isZoomOut ? 0.5 : 2 });
      return this.updateViewport(newMapState, LINEAR_TRANSITION_PROPS);
    }

    /* eslint-disable complexity */
    // Default handler for the `keydown` event

  }, {
    key: '_onKeyDown',
    value: function _onKeyDown(event) {
      if (!this.keyboard) {
        return false;
      }
      var funcKey = this.isFunctionKeyPressed(event);
      var mapStateProps = this.mapStateProps;

      var newMapState = void 0;

      switch (event.srcEvent.keyCode) {
        case 189:
          // -
          if (funcKey) {
            newMapState = this.getMapState({ zoom: mapStateProps.zoom - 2 });
          } else {
            newMapState = this.getMapState({ zoom: mapStateProps.zoom - 1 });
          }
          break;
        case 187:
          // +
          if (funcKey) {
            newMapState = this.getMapState({ zoom: mapStateProps.zoom + 2 });
          } else {
            newMapState = this.getMapState({ zoom: mapStateProps.zoom + 1 });
          }
          break;
        case 37:
          // left
          if (funcKey) {
            newMapState = this.getMapState({ bearing: mapStateProps.bearing - 15 });
          } else {
            newMapState = this.mapState.pan({ pos: [100, 0], startPos: [0, 0] });
          }
          break;
        case 39:
          // right
          if (funcKey) {
            newMapState = this.getMapState({ bearing: mapStateProps.bearing + 15 });
          } else {
            newMapState = this.mapState.pan({ pos: [-100, 0], startPos: [0, 0] });
          }
          break;
        case 38:
          // up
          if (funcKey) {
            newMapState = this.getMapState({ pitch: mapStateProps.pitch + 10 });
          } else {
            newMapState = this.mapState.pan({ pos: [0, 100], startPos: [0, 0] });
          }
          break;
        case 40:
          // down
          if (funcKey) {
            newMapState = this.getMapState({ pitch: mapStateProps.pitch - 10 });
          } else {
            newMapState = this.mapState.pan({ pos: [0, -100], startPos: [0, 0] });
          }
          break;
        default:
          return false;
      }
      return this.updateViewport(newMapState, LINEAR_TRANSITION_PROPS);
    }
    /* eslint-enable complexity */

  }]);

  return MapControls;
}();

export default MapControls;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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