var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { PureComponent, createElement } from 'react';
import PropTypes from 'prop-types';

import StaticMap from './static-map';
import { MAPBOX_LIMITS } from '../utils/map-state';
import WebMercatorViewport from 'viewport-mercator-project';

import TransitionManager from '../utils/transition-manager';

import { EventManager } from 'mjolnir.js';
import MapControls from '../utils/map-controls';
import config from '../config';
import deprecateWarn from '../utils/deprecate-warn';

var propTypes = Object.assign({}, StaticMap.propTypes, {
  // Additional props on top of StaticMap

  /** Viewport constraints */
  // Max zoom level
  maxZoom: PropTypes.number,
  // Min zoom level
  minZoom: PropTypes.number,
  // Max pitch in degrees
  maxPitch: PropTypes.number,
  // Min pitch in degrees
  minPitch: PropTypes.number,

  /**
   * `onViewportChange` callback is fired when the user interacted with the
   * map. The object passed to the callback contains viewport properties
   * such as `longitude`, `latitude`, `zoom` etc.
   */
  onViewportChange: PropTypes.func,

  /** Viewport transition **/
  // transition duration for viewport change
  transitionDuration: PropTypes.number,
  // TransitionInterpolator instance, can be used to perform custom transitions.
  transitionInterpolator: PropTypes.object,
  // type of interruption of current transition on update.
  transitionInterruption: PropTypes.number,
  // easing function
  transitionEasing: PropTypes.func,
  // transition status update functions
  onTransitionStart: PropTypes.func,
  onTransitionInterrupt: PropTypes.func,
  onTransitionEnd: PropTypes.func,

  /** Enables control event handling */
  // Scroll to zoom
  scrollZoom: PropTypes.bool,
  // Drag to pan
  dragPan: PropTypes.bool,
  // Drag to rotate
  dragRotate: PropTypes.bool,
  // Double click to zoom
  doubleClickZoom: PropTypes.bool,
  // Multitouch zoom
  touchZoom: PropTypes.bool,
  // Multitouch rotate
  touchRotate: PropTypes.bool,
  // Keyboard
  keyboard: PropTypes.bool,

  /**
     * Called when the map is hovered over.
     * @callback
     * @param {Object} event - The mouse event.
     * @param {[Number, Number]} event.lngLat - The coordinates of the pointer
     * @param {Array} event.features - The features under the pointer, using Mapbox's
     * queryRenderedFeatures API:
     * https://www.mapbox.com/mapbox-gl-js/api/#Map#queryRenderedFeatures
     * To make a layer interactive, set the `interactive` property in the
     * layer style to `true`. See Mapbox's style spec
     * https://www.mapbox.com/mapbox-gl-style-spec/#layer-interactive
     */
  onHover: PropTypes.func,
  /**
    * Called when the map is clicked.
    * @callback
    * @param {Object} event - The mouse event.
    * @param {[Number, Number]} event.lngLat - The coordinates of the pointer
    * @param {Array} event.features - The features under the pointer, using Mapbox's
    * queryRenderedFeatures API:
    * https://www.mapbox.com/mapbox-gl-js/api/#Map#queryRenderedFeatures
    * To make a layer interactive, set the `interactive` property in the
    * layer style to `true`. See Mapbox's style spec
    * https://www.mapbox.com/mapbox-gl-style-spec/#layer-interactive
    */
  onClick: PropTypes.func,

  /** Radius to detect features around a clicked point. Defaults to 0. */
  clickRadius: PropTypes.number,

  /** Accessor that returns a cursor style to show interactive state */
  getCursor: PropTypes.func,

  /** Advanced features */
  // Contraints for displaying the map. If not met, then the map is hidden.
  // Experimental! May be changed in minor version updates.
  visibilityConstraints: PropTypes.shape({
    minZoom: PropTypes.number,
    maxZoom: PropTypes.number,
    minPitch: PropTypes.number,
    maxPitch: PropTypes.number
  }),
  // A map control instance to replace the default map controls
  // The object must expose one property: `events` as an array of subscribed
  // event names; and two methods: `setState(state)` and `handle(event)`
  mapControls: PropTypes.shape({
    events: PropTypes.arrayOf(PropTypes.string),
    handleEvent: PropTypes.func
  })
});

var getDefaultCursor = function getDefaultCursor(_ref) {
  var isDragging = _ref.isDragging,
      isHovering = _ref.isHovering;
  return isDragging ? config.CURSOR.GRABBING : isHovering ? config.CURSOR.POINTER : config.CURSOR.GRAB;
};

var defaultProps = Object.assign({}, StaticMap.defaultProps, MAPBOX_LIMITS, TransitionManager.defaultProps, {
  onViewportChange: null,
  onClick: null,
  onHover: null,

  scrollZoom: true,
  dragPan: true,
  dragRotate: true,
  doubleClickZoom: true,

  clickRadius: 0,
  getCursor: getDefaultCursor,

  visibilityConstraints: MAPBOX_LIMITS
});

var childContextTypes = {
  viewport: PropTypes.instanceOf(WebMercatorViewport),
  isDragging: PropTypes.bool,
  eventManager: PropTypes.object
};

var InteractiveMap = function (_PureComponent) {
  _inherits(InteractiveMap, _PureComponent);

  _createClass(InteractiveMap, null, [{
    key: 'supported',
    value: function supported() {
      return StaticMap.supported();
    }
  }]);

  function InteractiveMap(props) {
    _classCallCheck(this, InteractiveMap);

    // Check for deprecated props
    var _this = _possibleConstructorReturn(this, (InteractiveMap.__proto__ || Object.getPrototypeOf(InteractiveMap)).call(this, props));

    deprecateWarn(props);

    _this.state = {
      // Whether the cursor is down
      isDragging: false,
      // Whether the cursor is over a clickable feature
      isHovering: false
    };

    // If props.mapControls is not provided, fallback to default MapControls instance
    // Cannot use defaultProps here because it needs to be per map instance
    _this._mapControls = props.mapControls || new MapControls();

    _this._eventManager = new EventManager(null, { rightButton: true });

    _this.getMap = _this.getMap.bind(_this);
    _this.queryRenderedFeatures = _this.queryRenderedFeatures.bind(_this);
    _this._checkVisibilityConstraints = _this._checkVisibilityConstraints.bind(_this);
    _this._getFeatures = _this._getFeatures.bind(_this);
    _this._onInteractiveStateChange = _this._onInteractiveStateChange.bind(_this);
    _this._getPos = _this._getPos.bind(_this);
    _this._onMouseMove = _this._onMouseMove.bind(_this);
    _this._onMouseClick = _this._onMouseClick.bind(_this);
    _this._eventCanvasLoaded = _this._eventCanvasLoaded.bind(_this);
    _this._staticMapLoaded = _this._staticMapLoaded.bind(_this);
    return _this;
  }

  _createClass(InteractiveMap, [{
    key: 'getChildContext',
    value: function getChildContext() {
      return {
        viewport: new WebMercatorViewport(this.props),
        isDragging: this.state.isDragging,
        eventManager: this._eventManager
      };
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      var eventManager = this._eventManager;

      // Register additional event handlers for click and hover
      eventManager.on('mousemove', this._onMouseMove);
      eventManager.on('click', this._onMouseClick);

      this._mapControls.setOptions(Object.assign({}, this.props, {
        onStateChange: this._onInteractiveStateChange,
        eventManager: eventManager
      }));

      this._transitionManager = new TransitionManager(this.props);
    }
  }, {
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps) {
      this._mapControls.setOptions(nextProps);
      this._transitionManager.processViewportChange(nextProps);
    }
  }, {
    key: 'getMap',
    value: function getMap() {
      return this._map ? this._map.getMap() : null;
    }
  }, {
    key: 'queryRenderedFeatures',
    value: function queryRenderedFeatures(geometry, options) {
      return this._map.queryRenderedFeatures(geometry, options);
    }

    // Checks a visibilityConstraints object to see if the map should be displayed

  }, {
    key: '_checkVisibilityConstraints',
    value: function _checkVisibilityConstraints(props) {
      var capitalize = function capitalize(s) {
        return s[0].toUpperCase() + s.slice(1);
      };

      var visibilityConstraints = props.visibilityConstraints;

      for (var propName in props) {
        var capitalizedPropName = capitalize(propName);
        var minPropName = 'min' + capitalizedPropName;
        var maxPropName = 'max' + capitalizedPropName;

        if (minPropName in visibilityConstraints && props[propName] < visibilityConstraints[minPropName]) {
          return false;
        }
        if (maxPropName in visibilityConstraints && props[propName] > visibilityConstraints[maxPropName]) {
          return false;
        }
      }
      return true;
    }
  }, {
    key: '_getFeatures',
    value: function _getFeatures(_ref2) {
      var pos = _ref2.pos,
          radius = _ref2.radius;

      var features = void 0;
      if (radius) {
        // Radius enables point features, like marker symbols, to be clicked.
        var size = radius;
        var bbox = [[pos[0] - size, pos[1] + size], [pos[0] + size, pos[1] - size]];
        features = this._map.queryRenderedFeatures(bbox);
      } else {
        features = this._map.queryRenderedFeatures(pos);
      }
      return features;
    }
  }, {
    key: '_onInteractiveStateChange',
    value: function _onInteractiveStateChange(_ref3) {
      var _ref3$isDragging = _ref3.isDragging,
          isDragging = _ref3$isDragging === undefined ? false : _ref3$isDragging;

      if (isDragging !== this.state.isDragging) {
        this.setState({ isDragging: isDragging });
      }
    }

    // HOVER AND CLICK

  }, {
    key: '_getPos',
    value: function _getPos(event) {
      var _event$offsetCenter = event.offsetCenter,
          x = _event$offsetCenter.x,
          y = _event$offsetCenter.y;

      return [x, y];
    }
  }, {
    key: '_onMouseMove',
    value: function _onMouseMove(event) {
      if (!this.state.isDragging) {
        var pos = this._getPos(event);
        var features = this._getFeatures({ pos: pos, radius: this.props.clickRadius });

        var isHovering = features && features.length > 0;
        if (isHovering !== this.state.isHovering) {
          this.setState({ isHovering: isHovering });
        }

        if (this.props.onHover) {
          var viewport = new WebMercatorViewport(this.props);
          event.lngLat = viewport.unproject(pos);
          event.features = features;

          this.props.onHover(event);
        }
      }
    }
  }, {
    key: '_onMouseClick',
    value: function _onMouseClick(event) {
      if (this.props.onClick) {
        var pos = this._getPos(event);
        var viewport = new WebMercatorViewport(this.props);
        event.lngLat = viewport.unproject(pos);
        event.features = this._getFeatures({ pos: pos, radius: this.props.clickRadius });

        this.props.onClick(event);
      }
    }
  }, {
    key: '_eventCanvasLoaded',
    value: function _eventCanvasLoaded(ref) {
      // This will be called with `null` after unmount, releasing event manager resource
      this._eventManager.setElement(ref);
    }
  }, {
    key: '_staticMapLoaded',
    value: function _staticMapLoaded(ref) {
      this._map = ref;
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          width = _props.width,
          height = _props.height,
          getCursor = _props.getCursor;


      var eventCanvasStyle = {
        width: width,
        height: height,
        position: 'relative',
        cursor: getCursor(this.state)
      };

      return createElement('div', {
        key: 'map-controls',
        ref: this._eventCanvasLoaded,
        style: eventCanvasStyle
      }, createElement(StaticMap, Object.assign({}, this.props, this._transitionManager && this._transitionManager.getViewportInTransition(), {
        visible: this._checkVisibilityConstraints(this.props),
        ref: this._staticMapLoaded,
        children: this.props.children
      })));
    }
  }]);

  return InteractiveMap;
}(PureComponent);

export default InteractiveMap;


InteractiveMap.displayName = 'InteractiveMap';
InteractiveMap.propTypes = propTypes;
InteractiveMap.defaultProps = defaultProps;
InteractiveMap.childContextTypes = childContextTypes;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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