var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { createElement } from 'react';
import PropTypes from 'prop-types';
import BaseControl from './base-control';

import MapState from '../utils/map-state';
import TransitionManager from '../utils/transition-manager';

import deprecateWarn from '../utils/deprecate-warn';

var LINEAR_TRANSITION_PROPS = Object.assign({}, TransitionManager.defaultProps, {
  transitionDuration: 300
});

var propTypes = Object.assign({}, BaseControl.propTypes, {
  // Custom className
  className: PropTypes.string,
  /**
    * `onViewportChange` callback is fired when the user interacted with the
    * map. The object passed to the callback contains `latitude`,
    * `longitude` and `zoom` and additional state information.
    */
  onViewportChange: PropTypes.func.isRequired,
  // Show/hide compass button
  showCompass: PropTypes.bool,
  // Show/hide zoom buttons
  showZoom: PropTypes.bool
});

var defaultProps = Object.assign({}, BaseControl.defaultProps, {
  className: '',
  onViewportChange: function onViewportChange() {},
  showCompass: true,
  showZoom: true
});

/*
 * PureComponent doesn't update when context changes, so
 * implementing our own shouldComponentUpdate here.
 */

var NavigationControl = function (_BaseControl) {
  _inherits(NavigationControl, _BaseControl);

  function NavigationControl(props) {
    _classCallCheck(this, NavigationControl);

    // Check for deprecated props
    var _this = _possibleConstructorReturn(this, (NavigationControl.__proto__ || Object.getPrototypeOf(NavigationControl)).call(this, props));

    deprecateWarn(props);

    _this._updateViewport = _this._updateViewport.bind(_this);
    _this._onZoomIn = _this._onZoomIn.bind(_this);
    _this._onZoomOut = _this._onZoomOut.bind(_this);
    _this._onResetNorth = _this._onResetNorth.bind(_this);
    _this._renderCompass = _this._renderCompass.bind(_this);
    _this._renderButton = _this._renderButton.bind(_this);
    return _this;
  }

  _createClass(NavigationControl, [{
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      return this.context.viewport.bearing !== nextContext.viewport.bearing;
    }
  }, {
    key: '_updateViewport',
    value: function _updateViewport(opts) {
      var viewport = this.context.viewport;

      var mapState = new MapState(Object.assign({}, viewport, opts));
      // TODO(deprecate): remove this check when `onChangeViewport` gets deprecated
      var onViewportChange = this.props.onChangeViewport || this.props.onViewportChange;
      var newViewport = Object.assign({}, mapState.getViewportProps(), LINEAR_TRANSITION_PROPS);

      onViewportChange(newViewport);
    }
  }, {
    key: '_onZoomIn',
    value: function _onZoomIn() {
      this._updateViewport({ zoom: this.context.viewport.zoom + 1 });
    }
  }, {
    key: '_onZoomOut',
    value: function _onZoomOut() {
      this._updateViewport({ zoom: this.context.viewport.zoom - 1 });
    }
  }, {
    key: '_onResetNorth',
    value: function _onResetNorth() {
      this._updateViewport({ bearing: 0, pitch: 0 });
    }
  }, {
    key: '_renderCompass',
    value: function _renderCompass() {
      var bearing = this.context.viewport.bearing;

      return createElement('span', {
        className: 'mapboxgl-ctrl-compass-arrow',
        style: { transform: 'rotate(' + bearing + 'deg)' }
      });
    }
  }, {
    key: '_renderButton',
    value: function _renderButton(type, label, callback, children) {
      return createElement('button', {
        key: type,
        className: 'mapboxgl-ctrl-icon mapboxgl-ctrl-' + type,
        type: 'button',
        title: label,
        onClick: callback,
        children: children
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          showCompass = _props.showCompass,
          showZoom = _props.showZoom;


      return createElement('div', {
        className: 'mapboxgl-ctrl mapboxgl-ctrl-group ' + className,
        ref: this._onContainerLoad
      }, [showZoom && this._renderButton('zoom-in', 'Zoom In', this._onZoomIn), showZoom && this._renderButton('zoom-out', 'Zoom Out', this._onZoomOut), showCompass && this._renderButton('compass', 'Reset North', this._onResetNorth, this._renderCompass())]);
    }
  }]);

  return NavigationControl;
}(BaseControl);

export default NavigationControl;


NavigationControl.displayName = 'NavigationControl';
NavigationControl.propTypes = propTypes;
NavigationControl.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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