var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Copyright (c) 2015 Uber Technologies, Inc.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/* global window, document, process */
import PropTypes from 'prop-types';

var isBrowser = !((typeof process === 'undefined' ? 'undefined' : _typeof(process)) === 'object' && String(process) === '[object process]' && !process.browser);

var mapboxgl = isBrowser ? require('mapbox-gl') : null;

function noop() {}

var propTypes = {
  // Creation parameters
  container: PropTypes.object, /** The container to have the map. */
  mapboxApiAccessToken: PropTypes.string, /** Mapbox API access token for Mapbox tiles/styles. */
  attributionControl: PropTypes.bool, /** Show attribution control or not. */
  preserveDrawingBuffer: PropTypes.bool, /** Useful when you want to export the canvas as a PNG. */
  onLoad: PropTypes.func, /** The onLoad callback for the map */
  onError: PropTypes.func, /** The onError callback for the map */
  reuseMaps: PropTypes.bool,
  transformRequest: PropTypes.func, /** The transformRequest callback for the map */

  mapStyle: PropTypes.string, /** The Mapbox style. A string url to a MapboxGL style */
  visible: PropTypes.bool, /** Whether the map is visible */

  // Map view state
  width: PropTypes.number.isRequired, /** The width of the map. */
  height: PropTypes.number.isRequired, /** The height of the map. */
  longitude: PropTypes.number.isRequired, /** The longitude of the center of the map. */
  latitude: PropTypes.number.isRequired, /** The latitude of the center of the map. */
  zoom: PropTypes.number.isRequired, /** The tile zoom level of the map. */
  bearing: PropTypes.number, /** Specify the bearing of the viewport */
  pitch: PropTypes.number, /** Specify the pitch of the viewport */

  // Note: Non-public API, see https://github.com/mapbox/mapbox-gl-js/issues/1137
  altitude: PropTypes.number /** Altitude of the viewport camera. Default 1.5 "screen heights" */
};

var defaultProps = {
  mapboxApiAccessToken: getAccessToken(),
  preserveDrawingBuffer: false,
  attributionControl: true,
  preventStyleDiffing: false,
  onLoad: noop,
  onError: noop,
  reuseMaps: false,
  transformRequest: null,

  mapStyle: 'mapbox://styles/mapbox/light-v8',
  visible: true,

  bearing: 0,
  pitch: 0,
  altitude: 1.5
};

// Try to get access token from URL, env, local storage or config
export function getAccessToken() {
  var accessToken = null;

  if (typeof window !== 'undefined' && window.location) {
    var match = window.location.search.match(/access_token=([^&\/]*)/);
    accessToken = match && match[1];
  }

  if (!accessToken && typeof process !== 'undefined') {
    // Note: This depends on bundler plugins (e.g. webpack) inmporting environment correctly
    accessToken = accessToken || process.env.MapboxAccessToken; // eslint-disable-line
  }

  return accessToken || null;
}

// Helper function to merge defaultProps and check prop types
function checkPropTypes(props) {
  var component = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'component';

  // TODO - check for production (unless done by prop types package?)
  if (props.debug) {
    PropTypes.checkPropTypes(propTypes, props, 'prop', component);
  }
}

// A small wrapper class for mapbox-gl
// - Provides a prop style interface (that can be trivially used by a React wrapper)
// - Makes sure mapbox doesn't crash under Node
// - Handles map reuse (to work around Mapbox resource leak issues)
// - Provides support for specifying tokens during development

var Mapbox = function () {
  _createClass(Mapbox, null, [{
    key: 'supported',
    value: function supported() {
      return mapboxgl && mapboxgl.supported();
    }
  }]);

  function Mapbox(props) {
    _classCallCheck(this, Mapbox);

    if (!mapboxgl) {
      throw new Error('Mapbox not supported');
    }

    if (!Mapbox.initialized && console.debug) {
      // eslint-disable-line
      Mapbox.initialized = true;
      console.debug('react-map-gl: using mapbox-gl v' + mapboxgl.version); // eslint-disable-line
    }

    this.props = {};
    this._initialize(props);
  }

  _createClass(Mapbox, [{
    key: 'finalize',
    value: function finalize() {
      if (!mapboxgl || !this._map) {
        return this;
      }

      this._destroy();
      return this;
    }
  }, {
    key: 'setProps',
    value: function setProps(props) {
      if (!mapboxgl || !this._map) {
        return this;
      }

      this._update(this.props, props);
      return this;
    }

    // Mapbox's map.resize() reads size from DOM, so DOM element must already be resized
    // In a system like React we must wait to read size until after render
    // (e.g. until "componentDidUpdate")

  }, {
    key: 'resize',
    value: function resize() {
      if (!mapboxgl || !this._map) {
        return this;
      }

      this._map.resize();
      return this;
    }

    // External apps can access map this way

  }, {
    key: 'getMap',
    value: function getMap() {
      return this._map;
    }

    // PRIVATE API

  }, {
    key: '_create',
    value: function _create(props) {
      // Reuse a saved map, if available
      if (props.reuseMaps && Mapbox.savedMap) {
        this._map = this.map = Mapbox.savedMap;
        // When reusing the saved map, we need to reparent the map(canvas) and other child nodes
        // intoto the new container from the props.
        // Step1: reparenting child nodes from old container to new container
        var oldContainer = this._map.getContainer();
        var newContainer = props.container;
        newContainer.classList.add('mapboxgl-map');
        while (oldContainer.childNodes.length > 0) {
          newContainer.appendChild(oldContainer.childNodes[0]);
        }
        // Step2: replace the internal container with new container from the react component
        this._map._container = newContainer;
        Mapbox.savedMap = null;
        // TODO - need to call onload again, need to track with Promise?
        props.onLoad();
      } else {
        var mapOptions = {
          container: props.container || document.body,
          center: [props.longitude, props.latitude],
          zoom: props.zoom,
          pitch: props.pitch,
          bearing: props.bearing,
          style: props.mapStyle,
          interactive: false,
          attributionControl: props.attributionControl,
          preserveDrawingBuffer: props.preserveDrawingBuffer
        };
        // We don't want to pass a null or no-op transformRequest function.
        if (props.transformRequest) {
          mapOptions.transformRequest = props.transformRequest;
        }
        this._map = this.map = new mapboxgl.Map(mapOptions);
        // Attach optional onLoad function
        this.map.once('load', props.onLoad);
        this.map.on('error', props.onError);
      }

      return this;
    }
  }, {
    key: '_destroy',
    value: function _destroy() {
      if (!Mapbox.savedMap) {
        Mapbox.savedMap = this._map;
      } else {
        this._map.remove();
      }
    }
  }, {
    key: '_initialize',
    value: function _initialize(props) {
      props = Object.assign({}, defaultProps, props);
      checkPropTypes(props, 'Mapbox');

      // Make empty string pick up default prop
      this.accessToken = props.mapboxApiAccessToken || defaultProps.mapboxApiAccessToken;

      // Creation only props
      if (mapboxgl) {
        if (!this.accessToken) {
          mapboxgl.accessToken = 'no-token'; // Prevents mapbox from throwing
        } else {
          mapboxgl.accessToken = this.accessToken;
        }
      }

      this._create(props);

      // Disable outline style
      var canvas = this.map.getCanvas();
      if (canvas) {
        canvas.style.outline = 'none';
      }

      this._updateMapViewport({}, props);
      this._updateMapSize({}, props);

      this.props = props;
    }
  }, {
    key: '_update',
    value: function _update(oldProps, newProps) {
      newProps = Object.assign({}, this.props, newProps);
      checkPropTypes(newProps, 'Mapbox');

      this._updateMapViewport(oldProps, newProps);
      this._updateMapSize(oldProps, newProps);

      this.props = newProps;
    }
  }, {
    key: '_updateMapViewport',
    value: function _updateMapViewport(oldProps, newProps) {
      var viewportChanged = newProps.latitude !== oldProps.latitude || newProps.longitude !== oldProps.longitude || newProps.zoom !== oldProps.zoom || newProps.pitch !== oldProps.pitch || newProps.bearing !== oldProps.bearing || newProps.altitude !== oldProps.altitude;

      if (viewportChanged) {
        this._map.jumpTo({
          center: [newProps.longitude, newProps.latitude],
          zoom: newProps.zoom,
          bearing: newProps.bearing,
          pitch: newProps.pitch
        });

        // TODO - jumpTo doesn't handle altitude
        if (newProps.altitude !== oldProps.altitude) {
          this._map.transform.altitude = newProps.altitude;
        }
      }
    }

    // Note: needs to be called after render (e.g. in componentDidUpdate)

  }, {
    key: '_updateMapSize',
    value: function _updateMapSize(oldProps, newProps) {
      var sizeChanged = oldProps.width !== newProps.width || oldProps.height !== newProps.height;
      if (sizeChanged) {
        this._map.resize();
      }
    }
  }]);

  return Mapbox;
}();

export default Mapbox;


Mapbox.propTypes = propTypes;
Mapbox.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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