
var WRAPPED_ANGULAR_PROPS = {
  longitude: 1,
  bearing: 1
};

export function mod(value, divisor) {
  var modulus = value % divisor;
  return modulus < 0 ? divisor + modulus : modulus;
}

export function lerp(start, end, step) {
  if (Array.isArray(start)) {
    return start.map(function (element, index) {
      return lerp(element, end[index], step);
    });
  }
  return step * end + (1 - step) * start;
}

export function isValid(prop) {
  return Number.isFinite(prop) || Array.isArray(prop);
}

function isWrappedAngularProp(propName) {
  return WRAPPED_ANGULAR_PROPS[propName];
}

export function getEndValueByShortestPath(propName, startValue, endValue) {
  if (isWrappedAngularProp(propName) && Math.abs(endValue - startValue) > 180) {
    endValue = endValue < 0 ? endValue + 360 : endValue - 360;
  }
  return endValue;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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