var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

import React from 'react';
import classnames from 'classnames';
//
import _ from './utils';
import Pagination from './pagination';

var emptyObj = function emptyObj() {
  return {};
};

export default {
  // General
  data: [],
  loading: false,
  showPagination: true,
  showPaginationTop: false,
  showPaginationBottom: true,
  showPageSizeOptions: true,
  pageSizeOptions: [5, 10, 20, 25, 50, 100],
  defaultPageSize: 20,
  showPageJump: true,
  collapseOnSortingChange: true,
  collapseOnPageChange: true,
  collapseOnDataChange: true,
  freezeWhenExpanded: false,
  sortable: true,
  multiSort: true,
  resizable: true,
  filterable: false,
  defaultSortDesc: false,
  defaultSorted: [],
  defaultFiltered: [],
  defaultResized: [],
  defaultExpanded: {},
  // eslint-disable-next-line no-unused-vars
  defaultFilterMethod: function defaultFilterMethod(filter, row, column) {
    var id = filter.pivotId || filter.id;
    return row[id] !== undefined ? String(row[id]).startsWith(filter.value) : true;
  },
  // eslint-disable-next-line no-unused-vars
  defaultSortMethod: function defaultSortMethod(a, b, desc) {
    // force null and undefined to the bottom
    a = a === null || a === undefined ? '' : a;
    b = b === null || b === undefined ? '' : b;
    // force any string values to lowercase
    a = typeof a === 'string' ? a.toLowerCase() : a;
    b = typeof b === 'string' ? b.toLowerCase() : b;
    // Return either 1 or -1 to indicate a sort priority
    if (a > b) {
      return 1;
    }
    if (a < b) {
      return -1;
    }
    // returning 0, undefined or any falsey value will use subsequent sorts or
    // the index as a tiebreaker
    return 0;
  },

  // Controlled State Props
  // page: undefined,
  // pageSize: undefined,
  // sorted: [],
  // filtered: [],
  // resized: [],
  // expanded: {},

  // Controlled State Callbacks
  onPageChange: undefined,
  onPageSizeChange: undefined,
  onSortedChange: undefined,
  onFilteredChange: undefined,
  onResizedChange: undefined,
  onExpandedChange: undefined,

  // Pivoting
  pivotBy: undefined,

  // Key Constants
  pivotValKey: '_pivotVal',
  pivotIDKey: '_pivotID',
  subRowsKey: '_subRows',
  aggregatedKey: '_aggregated',
  nestingLevelKey: '_nestingLevel',
  originalKey: '_original',
  indexKey: '_index',
  groupedByPivotKey: '_groupedByPivot',

  // Server-side Callbacks
  onFetchData: function onFetchData() {
    return null;
  },

  // Classes
  className: '',
  style: {},

  // Component decorators
  getProps: emptyObj,
  getTableProps: emptyObj,
  getTheadGroupProps: emptyObj,
  getTheadGroupTrProps: emptyObj,
  getTheadGroupThProps: emptyObj,
  getTheadProps: emptyObj,
  getTheadTrProps: emptyObj,
  getTheadThProps: emptyObj,
  getTheadFilterProps: emptyObj,
  getTheadFilterTrProps: emptyObj,
  getTheadFilterThProps: emptyObj,
  getTbodyProps: emptyObj,
  getTrGroupProps: emptyObj,
  getTrProps: emptyObj,
  getTdProps: emptyObj,
  getTfootProps: emptyObj,
  getTfootTrProps: emptyObj,
  getTfootTdProps: emptyObj,
  getPaginationProps: emptyObj,
  getLoadingProps: emptyObj,
  getNoDataProps: emptyObj,
  getResizerProps: emptyObj,

  // Global Column Defaults
  column: {
    // Renderers
    Cell: undefined,
    Header: undefined,
    Footer: undefined,
    Aggregated: undefined,
    Pivot: undefined,
    PivotValue: undefined,
    Expander: undefined,
    Filter: undefined,
    // All Columns
    sortable: undefined, // use table default
    resizable: undefined, // use table default
    filterable: undefined, // use table default
    show: true,
    minWidth: 100,
    // Cells only
    className: '',
    style: {},
    getProps: emptyObj,
    // Pivot only
    aggregate: undefined,
    // Headers only
    headerClassName: '',
    headerStyle: {},
    getHeaderProps: emptyObj,
    // Footers only
    footerClassName: '',
    footerStyle: {},
    getFooterProps: emptyObj,
    filterMethod: undefined,
    filterAll: false,
    sortMethod: undefined
  },

  // Global Expander Column Defaults
  expanderDefaults: {
    sortable: false,
    resizable: false,
    filterable: false,
    width: 35
  },

  pivotDefaults: {
    // extend the defaults for pivoted columns here
  },

  // Text
  previousText: 'Previous',
  nextText: 'Next',
  loadingText: 'Loading...',
  noDataText: 'No rows found',
  pageText: 'Page',
  ofText: 'of',
  rowsText: 'rows',

  // Components
  TableComponent: function TableComponent(_ref) {
    var children = _ref.children,
        className = _ref.className,
        rest = _objectWithoutProperties(_ref, ['children', 'className']);

    return React.createElement(
      'div',
      _extends({
        className: classnames('rt-table', className),
        role: 'grid'
        // tabIndex='0'
      }, rest),
      children
    );
  },
  TheadComponent: _.makeTemplateComponent('rt-thead', 'Thead'),
  TbodyComponent: _.makeTemplateComponent('rt-tbody', 'Tbody'),
  TrGroupComponent: function TrGroupComponent(_ref2) {
    var children = _ref2.children,
        className = _ref2.className,
        rest = _objectWithoutProperties(_ref2, ['children', 'className']);

    return React.createElement(
      'div',
      _extends({
        className: classnames('rt-tr-group', className),
        role: 'rowgroup'
      }, rest),
      children
    );
  },
  TrComponent: function TrComponent(_ref3) {
    var children = _ref3.children,
        className = _ref3.className,
        rest = _objectWithoutProperties(_ref3, ['children', 'className']);

    return React.createElement(
      'div',
      _extends({
        className: classnames('rt-tr', className),
        role: 'row'
      }, rest),
      children
    );
  },
  ThComponent: function ThComponent(_ref4) {
    var toggleSort = _ref4.toggleSort,
        className = _ref4.className,
        children = _ref4.children,
        rest = _objectWithoutProperties(_ref4, ['toggleSort', 'className', 'children']);

    return React.createElement(
      'div',
      _extends({
        className: classnames('rt-th', className),
        onClick: function onClick(e) {
          return toggleSort && toggleSort(e);
        },
        role: 'columnheader',
        tabIndex: '-1' // Resolves eslint issues without implementing keyboard navigation incorrectly
      }, rest),
      children
    );
  },
  TdComponent: function TdComponent(_ref5) {
    var toggleSort = _ref5.toggleSort,
        className = _ref5.className,
        children = _ref5.children,
        rest = _objectWithoutProperties(_ref5, ['toggleSort', 'className', 'children']);

    return React.createElement(
      'div',
      _extends({
        className: classnames('rt-td', className),
        role: 'gridcell'
      }, rest),
      children
    );
  },
  TfootComponent: _.makeTemplateComponent('rt-tfoot', 'Tfoot'),
  FilterComponent: function FilterComponent(_ref6) {
    var filter = _ref6.filter,
        _onChange = _ref6.onChange;
    return React.createElement('input', {
      type: 'text',
      style: {
        width: '100%'
      },
      value: filter ? filter.value : '',
      onChange: function onChange(event) {
        return _onChange(event.target.value);
      }
    });
  },
  ExpanderComponent: function ExpanderComponent(_ref7) {
    var isExpanded = _ref7.isExpanded;
    return React.createElement(
      'div',
      { className: classnames('rt-expander', isExpanded && '-open') },
      '\u2022'
    );
  },
  PivotValueComponent: function PivotValueComponent(_ref8) {
    var subRows = _ref8.subRows,
        value = _ref8.value;
    return React.createElement(
      'span',
      null,
      value,
      ' ',
      subRows && '(' + subRows.length + ')'
    );
  },
  AggregatedComponent: function AggregatedComponent(_ref9) {
    var subRows = _ref9.subRows,
        column = _ref9.column;

    var previewValues = subRows.filter(function (d) {
      return typeof d[column.id] !== 'undefined';
    }).map(function (row, i) {
      return (
        // eslint-disable-next-line react/no-array-index-key
        React.createElement(
          'span',
          { key: i },
          row[column.id],
          i < subRows.length - 1 ? ', ' : ''
        )
      );
    });
    return React.createElement(
      'span',
      null,
      previewValues
    );
  },
  PivotComponent: undefined, // this is a computed default generated using
  // the ExpanderComponent and PivotValueComponent at run-time in methods.js
  PaginationComponent: Pagination,
  PreviousComponent: undefined,
  NextComponent: undefined,
  LoadingComponent: function LoadingComponent(_ref10) {
    var className = _ref10.className,
        loading = _ref10.loading,
        loadingText = _ref10.loadingText,
        rest = _objectWithoutProperties(_ref10, ['className', 'loading', 'loadingText']);

    return React.createElement(
      'div',
      _extends({
        className: classnames('-loading', { '-active': loading }, className)
      }, rest),
      React.createElement(
        'div',
        { className: '-loading-inner' },
        loadingText
      )
    );
  },
  NoDataComponent: _.makeTemplateComponent('rt-noData', 'NoData'),
  ResizerComponent: _.makeTemplateComponent('rt-resizer', 'Resizer'),
  PadRowComponent: function PadRowComponent() {
    return React.createElement(
      'span',
      null,
      '\xA0'
    );
  }
};
//# sourceMappingURL=data:application/json;base64,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