var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

export default (function (Base) {
  return function (_Base) {
    _inherits(_class, _Base);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).apply(this, arguments));
    }

    _createClass(_class, [{
      key: 'componentWillMount',
      value: function componentWillMount() {
        this.setStateWithData(this.getDataModel(this.getResolvedState()));
      }
    }, {
      key: 'componentDidMount',
      value: function componentDidMount() {
        this.fireFetchData();
      }
    }, {
      key: 'componentWillReceiveProps',
      value: function componentWillReceiveProps(nextProps, nextState) {
        var oldState = this.getResolvedState();
        var newState = this.getResolvedState(nextProps, nextState);

        // Do a deep compare of new and old `defaultOption` and
        // if they are different reset `option = defaultOption`
        var defaultableOptions = ['sorted', 'filtered', 'resized', 'expanded'];
        defaultableOptions.forEach(function (x) {
          var defaultName = 'default' + (x.charAt(0).toUpperCase() + x.slice(1));
          if (JSON.stringify(oldState[defaultName]) !== JSON.stringify(newState[defaultName])) {
            newState[x] = newState[defaultName];
          }
        });

        // If they change these table options, we need to reset defaults
        // or else we could get into a state where the user has changed the UI
        // and then disabled the ability to change it back.
        // e.g. If `filterable` has changed, set `filtered = defaultFiltered`
        var resettableOptions = ['sortable', 'filterable', 'resizable'];
        resettableOptions.forEach(function (x) {
          if (oldState[x] !== newState[x]) {
            var baseName = x.replace('able', '');
            var optionName = baseName + 'ed';
            var defaultName = 'default' + (optionName.charAt(0).toUpperCase() + optionName.slice(1));
            newState[optionName] = newState[defaultName];
          }
        });

        // Props that trigger a data update
        if (oldState.data !== newState.data || oldState.columns !== newState.columns || oldState.pivotBy !== newState.pivotBy || oldState.sorted !== newState.sorted || oldState.filtered !== newState.filtered) {
          this.setStateWithData(this.getDataModel(newState));
        }
      }
    }, {
      key: 'setStateWithData',
      value: function setStateWithData(newState, cb) {
        var _this2 = this;

        var oldState = this.getResolvedState();
        var newResolvedState = this.getResolvedState({}, newState);
        var freezeWhenExpanded = newResolvedState.freezeWhenExpanded;

        // Default to unfrozen state

        newResolvedState.frozen = false;

        // If freezeWhenExpanded is set, check for frozen conditions
        if (freezeWhenExpanded) {
          // if any rows are expanded, freeze the existing data and sorting
          var keys = Object.keys(newResolvedState.expanded);
          for (var i = 0; i < keys.length; i += 1) {
            if (newResolvedState.expanded[keys[i]]) {
              newResolvedState.frozen = true;
              break;
            }
          }
        }

        // If the data isn't frozen and either the data or
        // sorting model has changed, update the data
        if (oldState.frozen && !newResolvedState.frozen || oldState.sorted !== newResolvedState.sorted || oldState.filtered !== newResolvedState.filtered || oldState.showFilters !== newResolvedState.showFilters || !newResolvedState.frozen && oldState.resolvedData !== newResolvedState.resolvedData) {
          // Handle collapseOnsortedChange & collapseOnDataChange
          if (oldState.sorted !== newResolvedState.sorted && this.props.collapseOnSortingChange || oldState.filtered !== newResolvedState.filtered || oldState.showFilters !== newResolvedState.showFilters || oldState.sortedData && !newResolvedState.frozen && oldState.resolvedData !== newResolvedState.resolvedData && this.props.collapseOnDataChange) {
            newResolvedState.expanded = {};
          }

          Object.assign(newResolvedState, this.getSortedData(newResolvedState));
        }

        // Set page to 0 if filters change
        if (oldState.filtered !== newResolvedState.filtered) {
          newResolvedState.page = 0;
        }

        // Calculate pageSize all the time
        if (newResolvedState.sortedData) {
          newResolvedState.pages = newResolvedState.manual ? newResolvedState.pages : Math.ceil(newResolvedState.sortedData.length / newResolvedState.pageSize);
          newResolvedState.page = Math.max(newResolvedState.page >= newResolvedState.pages ? newResolvedState.pages - 1 : newResolvedState.page, 0);
        }

        return this.setState(newResolvedState, function () {
          if (cb) {
            cb();
          }
          if (oldState.page !== newResolvedState.page || oldState.pageSize !== newResolvedState.pageSize || oldState.sorted !== newResolvedState.sorted || oldState.filtered !== newResolvedState.filtered) {
            _this2.fireFetchData();
          }
        });
      }
    }]);

    return _class;
  }(Base);
});
//# sourceMappingURL=data:application/json;base64,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