import PropTypes from 'prop-types';

export default {
  // General
  data: PropTypes.array,
  loading: PropTypes.bool,
  showPagination: PropTypes.bool,
  showPaginationTop: PropTypes.bool,
  showPaginationBottom: PropTypes.bool,
  showPageSizeOptions: PropTypes.bool,
  pageSizeOptions: PropTypes.array,
  defaultPageSize: PropTypes.number,
  showPageJump: PropTypes.bool,
  collapseOnSortingChange: PropTypes.bool,
  collapseOnPageChange: PropTypes.bool,
  collapseOnDataChange: PropTypes.bool,
  freezeWhenExpanded: PropTypes.bool,
  sortable: PropTypes.bool,
  resizable: PropTypes.bool,
  filterable: PropTypes.bool,
  defaultSortDesc: PropTypes.bool,
  defaultSorted: PropTypes.array,
  defaultFiltered: PropTypes.array,
  defaultResized: PropTypes.array,
  defaultExpanded: PropTypes.object,
  defaultFilterMethod: PropTypes.func,
  defaultSortMethod: PropTypes.func,

  // Controlled State Callbacks
  onPageChange: PropTypes.func,
  onPageSizeChange: PropTypes.func,
  onSortedChange: PropTypes.func,
  onFilteredChange: PropTypes.func,
  onResizedChange: PropTypes.func,
  onExpandedChange: PropTypes.func,

  // Pivoting
  pivotBy: PropTypes.array,

  // Key Constants
  pivotValKey: PropTypes.string,
  pivotIDKey: PropTypes.string,
  subRowsKey: PropTypes.string,
  aggregatedKey: PropTypes.string,
  nestingLevelKey: PropTypes.string,
  originalKey: PropTypes.string,
  indexKey: PropTypes.string,
  groupedByPivotKey: PropTypes.string,

  // Server-side Callbacks
  onFetchData: PropTypes.func,

  // Classes
  className: PropTypes.string,
  style: PropTypes.object,

  // Component decorators
  getProps: PropTypes.func,
  getTableProps: PropTypes.func,
  getTheadGroupProps: PropTypes.func,
  getTheadGroupTrProps: PropTypes.func,
  getTheadGroupThProps: PropTypes.func,
  getTheadProps: PropTypes.func,
  getTheadTrProps: PropTypes.func,
  getTheadThProps: PropTypes.func,
  getTheadFilterProps: PropTypes.func,
  getTheadFilterTrProps: PropTypes.func,
  getTheadFilterThProps: PropTypes.func,
  getTbodyProps: PropTypes.func,
  getTrGroupProps: PropTypes.func,
  getTrProps: PropTypes.func,
  getTdProps: PropTypes.func,
  getTfootProps: PropTypes.func,
  getTfootTrProps: PropTypes.func,
  getTfootTdProps: PropTypes.func,
  getPaginationProps: PropTypes.func,
  getLoadingProps: PropTypes.func,
  getNoDataProps: PropTypes.func,
  getResizerProps: PropTypes.func,

  // Global Column Defaults
  columns: PropTypes.arrayOf(PropTypes.shape({
    // Renderers
    Cell: PropTypes.oneOfType([PropTypes.element, PropTypes.string, PropTypes.func]),
    Header: PropTypes.oneOfType([PropTypes.element, PropTypes.string, PropTypes.func]),
    Footer: PropTypes.oneOfType([PropTypes.element, PropTypes.string, PropTypes.func]),
    Aggregated: PropTypes.oneOfType([PropTypes.element, PropTypes.string, PropTypes.func]),
    Pivot: PropTypes.oneOfType([PropTypes.element, PropTypes.string, PropTypes.func]),
    PivotValue: PropTypes.oneOfType([PropTypes.element, PropTypes.string, PropTypes.func]),
    Expander: PropTypes.oneOfType([PropTypes.element, PropTypes.string, PropTypes.func]),
    Filter: PropTypes.oneOfType([PropTypes.element, PropTypes.func]),

    // All Columns
    sortable: PropTypes.bool, // use table default
    resizable: PropTypes.bool, // use table default
    filterable: PropTypes.bool, // use table default
    show: PropTypes.bool,
    minWidth: PropTypes.number,

    // Cells only
    className: PropTypes.string,
    style: PropTypes.object,
    getProps: PropTypes.func,

    // Pivot only
    aggregate: PropTypes.func,

    // Headers only
    headerClassName: PropTypes.string,
    headerStyle: PropTypes.object,
    getHeaderProps: PropTypes.func,

    // Footers only
    footerClassName: PropTypes.string,
    footerStyle: PropTypes.object,
    getFooterProps: PropTypes.object,
    filterMethod: PropTypes.func,
    filterAll: PropTypes.bool,
    sortMethod: PropTypes.func
  })),

  // Global Expander Column Defaults
  expanderDefaults: PropTypes.shape({
    sortable: PropTypes.bool,
    resizable: PropTypes.bool,
    filterable: PropTypes.bool,
    width: PropTypes.number
  }),

  pivotDefaults: PropTypes.object,

  // Text
  previousText: PropTypes.node,
  nextText: PropTypes.node,
  loadingText: PropTypes.node,
  noDataText: PropTypes.node,
  pageText: PropTypes.node,
  ofText: PropTypes.node,
  rowsText: PropTypes.node,

  // Components
  TableComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  TheadComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  TbodyComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  TrGroupComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  TrComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  ThComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  TdComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  TfootComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  FilterComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  ExpanderComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  PivotValueComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  AggregatedComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  // this is a computed default generated using
  PivotComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  // the ExpanderComponent and PivotValueComponent at run-time in methods.js
  PaginationComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  PreviousComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  NextComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  LoadingComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  NoDataComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  ResizerComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element]),
  PadRowComponent: PropTypes.oneOfType([PropTypes.func, PropTypes.element])
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9wcm9wVHlwZXMuanMiXSwibmFtZXMiOlsiUHJvcFR5cGVzIiwiZGF0YSIsImFycmF5IiwibG9hZGluZyIsImJvb2wiLCJzaG93UGFnaW5hdGlvbiIsInNob3dQYWdpbmF0aW9uVG9wIiwic2hvd1BhZ2luYXRpb25Cb3R0b20iLCJzaG93UGFnZVNpemVPcHRpb25zIiwicGFnZVNpemVPcHRpb25zIiwiZGVmYXVsdFBhZ2VTaXplIiwibnVtYmVyIiwic2hvd1BhZ2VKdW1wIiwiY29sbGFwc2VPblNvcnRpbmdDaGFuZ2UiLCJjb2xsYXBzZU9uUGFnZUNoYW5nZSIsImNvbGxhcHNlT25EYXRhQ2hhbmdlIiwiZnJlZXplV2hlbkV4cGFuZGVkIiwic29ydGFibGUiLCJyZXNpemFibGUiLCJmaWx0ZXJhYmxlIiwiZGVmYXVsdFNvcnREZXNjIiwiZGVmYXVsdFNvcnRlZCIsImRlZmF1bHRGaWx0ZXJlZCIsImRlZmF1bHRSZXNpemVkIiwiZGVmYXVsdEV4cGFuZGVkIiwib2JqZWN0IiwiZGVmYXVsdEZpbHRlck1ldGhvZCIsImZ1bmMiLCJkZWZhdWx0U29ydE1ldGhvZCIsIm9uUGFnZUNoYW5nZSIsIm9uUGFnZVNpemVDaGFuZ2UiLCJvblNvcnRlZENoYW5nZSIsIm9uRmlsdGVyZWRDaGFuZ2UiLCJvblJlc2l6ZWRDaGFuZ2UiLCJvbkV4cGFuZGVkQ2hhbmdlIiwicGl2b3RCeSIsInBpdm90VmFsS2V5Iiwic3RyaW5nIiwicGl2b3RJREtleSIsInN1YlJvd3NLZXkiLCJhZ2dyZWdhdGVkS2V5IiwibmVzdGluZ0xldmVsS2V5Iiwib3JpZ2luYWxLZXkiLCJpbmRleEtleSIsImdyb3VwZWRCeVBpdm90S2V5Iiwib25GZXRjaERhdGEiLCJjbGFzc05hbWUiLCJzdHlsZSIsImdldFByb3BzIiwiZ2V0VGFibGVQcm9wcyIsImdldFRoZWFkR3JvdXBQcm9wcyIsImdldFRoZWFkR3JvdXBUclByb3BzIiwiZ2V0VGhlYWRHcm91cFRoUHJvcHMiLCJnZXRUaGVhZFByb3BzIiwiZ2V0VGhlYWRUclByb3BzIiwiZ2V0VGhlYWRUaFByb3BzIiwiZ2V0VGhlYWRGaWx0ZXJQcm9wcyIsImdldFRoZWFkRmlsdGVyVHJQcm9wcyIsImdldFRoZWFkRmlsdGVyVGhQcm9wcyIsImdldFRib2R5UHJvcHMiLCJnZXRUckdyb3VwUHJvcHMiLCJnZXRUclByb3BzIiwiZ2V0VGRQcm9wcyIsImdldFRmb290UHJvcHMiLCJnZXRUZm9vdFRyUHJvcHMiLCJnZXRUZm9vdFRkUHJvcHMiLCJnZXRQYWdpbmF0aW9uUHJvcHMiLCJnZXRMb2FkaW5nUHJvcHMiLCJnZXROb0RhdGFQcm9wcyIsImdldFJlc2l6ZXJQcm9wcyIsImNvbHVtbnMiLCJhcnJheU9mIiwic2hhcGUiLCJDZWxsIiwib25lT2ZUeXBlIiwiZWxlbWVudCIsIkhlYWRlciIsIkZvb3RlciIsIkFnZ3JlZ2F0ZWQiLCJQaXZvdCIsIlBpdm90VmFsdWUiLCJFeHBhbmRlciIsIkZpbHRlciIsInNob3ciLCJtaW5XaWR0aCIsImFnZ3JlZ2F0ZSIsImhlYWRlckNsYXNzTmFtZSIsImhlYWRlclN0eWxlIiwiZ2V0SGVhZGVyUHJvcHMiLCJmb290ZXJDbGFzc05hbWUiLCJmb290ZXJTdHlsZSIsImdldEZvb3RlclByb3BzIiwiZmlsdGVyTWV0aG9kIiwiZmlsdGVyQWxsIiwic29ydE1ldGhvZCIsImV4cGFuZGVyRGVmYXVsdHMiLCJ3aWR0aCIsInBpdm90RGVmYXVsdHMiLCJwcmV2aW91c1RleHQiLCJub2RlIiwibmV4dFRleHQiLCJsb2FkaW5nVGV4dCIsIm5vRGF0YVRleHQiLCJwYWdlVGV4dCIsIm9mVGV4dCIsInJvd3NUZXh0IiwiVGFibGVDb21wb25lbnQiLCJUaGVhZENvbXBvbmVudCIsIlRib2R5Q29tcG9uZW50IiwiVHJHcm91cENvbXBvbmVudCIsIlRyQ29tcG9uZW50IiwiVGhDb21wb25lbnQiLCJUZENvbXBvbmVudCIsIlRmb290Q29tcG9uZW50IiwiRmlsdGVyQ29tcG9uZW50IiwiRXhwYW5kZXJDb21wb25lbnQiLCJQaXZvdFZhbHVlQ29tcG9uZW50IiwiQWdncmVnYXRlZENvbXBvbmVudCIsIlBpdm90Q29tcG9uZW50IiwiUGFnaW5hdGlvbkNvbXBvbmVudCIsIlByZXZpb3VzQ29tcG9uZW50IiwiTmV4dENvbXBvbmVudCIsIkxvYWRpbmdDb21wb25lbnQiLCJOb0RhdGFDb21wb25lbnQiLCJSZXNpemVyQ29tcG9uZW50IiwiUGFkUm93Q29tcG9uZW50Il0sIm1hcHBpbmdzIjoiQUFBQSxPQUFPQSxTQUFQLE1BQXNCLFlBQXRCOztBQUVBLGVBQWU7QUFDYjtBQUNBQyxRQUFNRCxVQUFVRSxLQUZIO0FBR2JDLFdBQVNILFVBQVVJLElBSE47QUFJYkMsa0JBQWdCTCxVQUFVSSxJQUpiO0FBS2JFLHFCQUFtQk4sVUFBVUksSUFMaEI7QUFNYkcsd0JBQXNCUCxVQUFVSSxJQU5uQjtBQU9iSSx1QkFBcUJSLFVBQVVJLElBUGxCO0FBUWJLLG1CQUFpQlQsVUFBVUUsS0FSZDtBQVNiUSxtQkFBaUJWLFVBQVVXLE1BVGQ7QUFVYkMsZ0JBQWNaLFVBQVVJLElBVlg7QUFXYlMsMkJBQXlCYixVQUFVSSxJQVh0QjtBQVliVSx3QkFBc0JkLFVBQVVJLElBWm5CO0FBYWJXLHdCQUFzQmYsVUFBVUksSUFibkI7QUFjYlksc0JBQW9CaEIsVUFBVUksSUFkakI7QUFlYmEsWUFBVWpCLFVBQVVJLElBZlA7QUFnQmJjLGFBQVdsQixVQUFVSSxJQWhCUjtBQWlCYmUsY0FBWW5CLFVBQVVJLElBakJUO0FBa0JiZ0IsbUJBQWlCcEIsVUFBVUksSUFsQmQ7QUFtQmJpQixpQkFBZXJCLFVBQVVFLEtBbkJaO0FBb0Jib0IsbUJBQWlCdEIsVUFBVUUsS0FwQmQ7QUFxQmJxQixrQkFBZ0J2QixVQUFVRSxLQXJCYjtBQXNCYnNCLG1CQUFpQnhCLFVBQVV5QixNQXRCZDtBQXVCYkMsdUJBQXFCMUIsVUFBVTJCLElBdkJsQjtBQXdCYkMscUJBQW1CNUIsVUFBVTJCLElBeEJoQjs7QUEwQmI7QUFDQUUsZ0JBQWM3QixVQUFVMkIsSUEzQlg7QUE0QmJHLG9CQUFrQjlCLFVBQVUyQixJQTVCZjtBQTZCYkksa0JBQWdCL0IsVUFBVTJCLElBN0JiO0FBOEJiSyxvQkFBa0JoQyxVQUFVMkIsSUE5QmY7QUErQmJNLG1CQUFpQmpDLFVBQVUyQixJQS9CZDtBQWdDYk8sb0JBQWtCbEMsVUFBVTJCLElBaENmOztBQWtDYjtBQUNBUSxXQUFTbkMsVUFBVUUsS0FuQ047O0FBcUNiO0FBQ0FrQyxlQUFhcEMsVUFBVXFDLE1BdENWO0FBdUNiQyxjQUFZdEMsVUFBVXFDLE1BdkNUO0FBd0NiRSxjQUFZdkMsVUFBVXFDLE1BeENUO0FBeUNiRyxpQkFBZXhDLFVBQVVxQyxNQXpDWjtBQTBDYkksbUJBQWlCekMsVUFBVXFDLE1BMUNkO0FBMkNiSyxlQUFhMUMsVUFBVXFDLE1BM0NWO0FBNENiTSxZQUFVM0MsVUFBVXFDLE1BNUNQO0FBNkNiTyxxQkFBbUI1QyxVQUFVcUMsTUE3Q2hCOztBQStDYjtBQUNBUSxlQUFhN0MsVUFBVTJCLElBaERWOztBQWtEYjtBQUNBbUIsYUFBVzlDLFVBQVVxQyxNQW5EUjtBQW9EYlUsU0FBTy9DLFVBQVV5QixNQXBESjs7QUFzRGI7QUFDQXVCLFlBQVVoRCxVQUFVMkIsSUF2RFA7QUF3RGJzQixpQkFBZWpELFVBQVUyQixJQXhEWjtBQXlEYnVCLHNCQUFvQmxELFVBQVUyQixJQXpEakI7QUEwRGJ3Qix3QkFBc0JuRCxVQUFVMkIsSUExRG5CO0FBMkRieUIsd0JBQXNCcEQsVUFBVTJCLElBM0RuQjtBQTREYjBCLGlCQUFlckQsVUFBVTJCLElBNURaO0FBNkRiMkIsbUJBQWlCdEQsVUFBVTJCLElBN0RkO0FBOERiNEIsbUJBQWlCdkQsVUFBVTJCLElBOURkO0FBK0RiNkIsdUJBQXFCeEQsVUFBVTJCLElBL0RsQjtBQWdFYjhCLHlCQUF1QnpELFVBQVUyQixJQWhFcEI7QUFpRWIrQix5QkFBdUIxRCxVQUFVMkIsSUFqRXBCO0FBa0ViZ0MsaUJBQWUzRCxVQUFVMkIsSUFsRVo7QUFtRWJpQyxtQkFBaUI1RCxVQUFVMkIsSUFuRWQ7QUFvRWJrQyxjQUFZN0QsVUFBVTJCLElBcEVUO0FBcUVibUMsY0FBWTlELFVBQVUyQixJQXJFVDtBQXNFYm9DLGlCQUFlL0QsVUFBVTJCLElBdEVaO0FBdUVicUMsbUJBQWlCaEUsVUFBVTJCLElBdkVkO0FBd0Vic0MsbUJBQWlCakUsVUFBVTJCLElBeEVkO0FBeUVidUMsc0JBQW9CbEUsVUFBVTJCLElBekVqQjtBQTBFYndDLG1CQUFpQm5FLFVBQVUyQixJQTFFZDtBQTJFYnlDLGtCQUFnQnBFLFVBQVUyQixJQTNFYjtBQTRFYjBDLG1CQUFpQnJFLFVBQVUyQixJQTVFZDs7QUE4RWI7QUFDQTJDLFdBQVN0RSxVQUFVdUUsT0FBVixDQUNQdkUsVUFBVXdFLEtBQVYsQ0FBZ0I7QUFDZDtBQUNBQyxVQUFNekUsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FDeEIxRSxVQUFVMkUsT0FEYyxFQUV4QjNFLFVBQVVxQyxNQUZjLEVBR3hCckMsVUFBVTJCLElBSGMsQ0FBcEIsQ0FGUTtBQU9kaUQsWUFBUTVFLFVBQVUwRSxTQUFWLENBQW9CLENBQzFCMUUsVUFBVTJFLE9BRGdCLEVBRTFCM0UsVUFBVXFDLE1BRmdCLEVBRzFCckMsVUFBVTJCLElBSGdCLENBQXBCLENBUE07QUFZZGtELFlBQVE3RSxVQUFVMEUsU0FBVixDQUFvQixDQUMxQjFFLFVBQVUyRSxPQURnQixFQUUxQjNFLFVBQVVxQyxNQUZnQixFQUcxQnJDLFVBQVUyQixJQUhnQixDQUFwQixDQVpNO0FBaUJkbUQsZ0JBQVk5RSxVQUFVMEUsU0FBVixDQUFvQixDQUM5QjFFLFVBQVUyRSxPQURvQixFQUU5QjNFLFVBQVVxQyxNQUZvQixFQUc5QnJDLFVBQVUyQixJQUhvQixDQUFwQixDQWpCRTtBQXNCZG9ELFdBQU8vRSxVQUFVMEUsU0FBVixDQUFvQixDQUN6QjFFLFVBQVUyRSxPQURlLEVBRXpCM0UsVUFBVXFDLE1BRmUsRUFHekJyQyxVQUFVMkIsSUFIZSxDQUFwQixDQXRCTztBQTJCZHFELGdCQUFZaEYsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FDOUIxRSxVQUFVMkUsT0FEb0IsRUFFOUIzRSxVQUFVcUMsTUFGb0IsRUFHOUJyQyxVQUFVMkIsSUFIb0IsQ0FBcEIsQ0EzQkU7QUFnQ2RzRCxjQUFVakYsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FDNUIxRSxVQUFVMkUsT0FEa0IsRUFFNUIzRSxVQUFVcUMsTUFGa0IsRUFHNUJyQyxVQUFVMkIsSUFIa0IsQ0FBcEIsQ0FoQ0k7QUFxQ2R1RCxZQUFRbEYsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyRSxPQUFYLEVBQW9CM0UsVUFBVTJCLElBQTlCLENBQXBCLENBckNNOztBQXVDZDtBQUNBVixjQUFVakIsVUFBVUksSUF4Q04sRUF3Q1k7QUFDMUJjLGVBQVdsQixVQUFVSSxJQXpDUCxFQXlDYTtBQUMzQmUsZ0JBQVluQixVQUFVSSxJQTFDUixFQTBDYztBQUM1QitFLFVBQU1uRixVQUFVSSxJQTNDRjtBQTRDZGdGLGNBQVVwRixVQUFVVyxNQTVDTjs7QUE4Q2Q7QUFDQW1DLGVBQVc5QyxVQUFVcUMsTUEvQ1A7QUFnRGRVLFdBQU8vQyxVQUFVeUIsTUFoREg7QUFpRGR1QixjQUFVaEQsVUFBVTJCLElBakROOztBQW1EZDtBQUNBMEQsZUFBV3JGLFVBQVUyQixJQXBEUDs7QUFzRGQ7QUFDQTJELHFCQUFpQnRGLFVBQVVxQyxNQXZEYjtBQXdEZGtELGlCQUFhdkYsVUFBVXlCLE1BeERUO0FBeURkK0Qsb0JBQWdCeEYsVUFBVTJCLElBekRaOztBQTJEZDtBQUNBOEQscUJBQWlCekYsVUFBVXFDLE1BNURiO0FBNkRkcUQsaUJBQWExRixVQUFVeUIsTUE3RFQ7QUE4RGRrRSxvQkFBZ0IzRixVQUFVeUIsTUE5RFo7QUErRGRtRSxrQkFBYzVGLFVBQVUyQixJQS9EVjtBQWdFZGtFLGVBQVc3RixVQUFVSSxJQWhFUDtBQWlFZDBGLGdCQUFZOUYsVUFBVTJCO0FBakVSLEdBQWhCLENBRE8sQ0EvRUk7O0FBcUpiO0FBQ0FvRSxvQkFBa0IvRixVQUFVd0UsS0FBVixDQUFnQjtBQUNoQ3ZELGNBQVVqQixVQUFVSSxJQURZO0FBRWhDYyxlQUFXbEIsVUFBVUksSUFGVztBQUdoQ2UsZ0JBQVluQixVQUFVSSxJQUhVO0FBSWhDNEYsV0FBT2hHLFVBQVVXO0FBSmUsR0FBaEIsQ0F0Skw7O0FBNkpic0YsaUJBQWVqRyxVQUFVeUIsTUE3Slo7O0FBK0piO0FBQ0F5RSxnQkFBY2xHLFVBQVVtRyxJQWhLWDtBQWlLYkMsWUFBVXBHLFVBQVVtRyxJQWpLUDtBQWtLYkUsZUFBYXJHLFVBQVVtRyxJQWxLVjtBQW1LYkcsY0FBWXRHLFVBQVVtRyxJQW5LVDtBQW9LYkksWUFBVXZHLFVBQVVtRyxJQXBLUDtBQXFLYkssVUFBUXhHLFVBQVVtRyxJQXJLTDtBQXNLYk0sWUFBVXpHLFVBQVVtRyxJQXRLUDs7QUF3S2I7QUFDQU8sa0JBQWdCMUcsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBektIO0FBMEtiZ0Msa0JBQWdCM0csVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBMUtIO0FBMktiaUMsa0JBQWdCNUcsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBM0tIO0FBNEtia0Msb0JBQWtCN0csVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBNUtMO0FBNktibUMsZUFBYTlHLFVBQVUwRSxTQUFWLENBQW9CLENBQUMxRSxVQUFVMkIsSUFBWCxFQUFpQjNCLFVBQVUyRSxPQUEzQixDQUFwQixDQTdLQTtBQThLYm9DLGVBQWEvRyxVQUFVMEUsU0FBVixDQUFvQixDQUFDMUUsVUFBVTJCLElBQVgsRUFBaUIzQixVQUFVMkUsT0FBM0IsQ0FBcEIsQ0E5S0E7QUErS2JxQyxlQUFhaEgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBL0tBO0FBZ0xic0Msa0JBQWdCakgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBaExIO0FBaUxidUMsbUJBQWlCbEgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBakxKO0FBa0xid0MscUJBQW1CbkgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBbExOO0FBbUxieUMsdUJBQXFCcEgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBbkxSO0FBb0xiMEMsdUJBQXFCckgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBcExSO0FBcUxiO0FBQ0EyQyxrQkFBZ0J0SCxVQUFVMEUsU0FBVixDQUFvQixDQUFDMUUsVUFBVTJCLElBQVgsRUFBaUIzQixVQUFVMkUsT0FBM0IsQ0FBcEIsQ0F0TEg7QUF1TGI7QUFDQTRDLHVCQUFxQnZILFVBQVUwRSxTQUFWLENBQW9CLENBQUMxRSxVQUFVMkIsSUFBWCxFQUFpQjNCLFVBQVUyRSxPQUEzQixDQUFwQixDQXhMUjtBQXlMYjZDLHFCQUFtQnhILFVBQVUwRSxTQUFWLENBQW9CLENBQUMxRSxVQUFVMkIsSUFBWCxFQUFpQjNCLFVBQVUyRSxPQUEzQixDQUFwQixDQXpMTjtBQTBMYjhDLGlCQUFlekgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBMUxGO0FBMkxiK0Msb0JBQWtCMUgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBM0xMO0FBNExiZ0QsbUJBQWlCM0gsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBNUxKO0FBNkxiaUQsb0JBQWtCNUgsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCLENBN0xMO0FBOExia0QsbUJBQWlCN0gsVUFBVTBFLFNBQVYsQ0FBb0IsQ0FBQzFFLFVBQVUyQixJQUFYLEVBQWlCM0IsVUFBVTJFLE9BQTNCLENBQXBCO0FBOUxKLENBQWYiLCJmaWxlIjoicHJvcFR5cGVzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJ1xuXG5leHBvcnQgZGVmYXVsdCB7XG4gIC8vIEdlbmVyYWxcbiAgZGF0YTogUHJvcFR5cGVzLmFycmF5LFxuICBsb2FkaW5nOiBQcm9wVHlwZXMuYm9vbCxcbiAgc2hvd1BhZ2luYXRpb246IFByb3BUeXBlcy5ib29sLFxuICBzaG93UGFnaW5hdGlvblRvcDogUHJvcFR5cGVzLmJvb2wsXG4gIHNob3dQYWdpbmF0aW9uQm90dG9tOiBQcm9wVHlwZXMuYm9vbCxcbiAgc2hvd1BhZ2VTaXplT3B0aW9uczogUHJvcFR5cGVzLmJvb2wsXG4gIHBhZ2VTaXplT3B0aW9uczogUHJvcFR5cGVzLmFycmF5LFxuICBkZWZhdWx0UGFnZVNpemU6IFByb3BUeXBlcy5udW1iZXIsXG4gIHNob3dQYWdlSnVtcDogUHJvcFR5cGVzLmJvb2wsXG4gIGNvbGxhcHNlT25Tb3J0aW5nQ2hhbmdlOiBQcm9wVHlwZXMuYm9vbCxcbiAgY29sbGFwc2VPblBhZ2VDaGFuZ2U6IFByb3BUeXBlcy5ib29sLFxuICBjb2xsYXBzZU9uRGF0YUNoYW5nZTogUHJvcFR5cGVzLmJvb2wsXG4gIGZyZWV6ZVdoZW5FeHBhbmRlZDogUHJvcFR5cGVzLmJvb2wsXG4gIHNvcnRhYmxlOiBQcm9wVHlwZXMuYm9vbCxcbiAgcmVzaXphYmxlOiBQcm9wVHlwZXMuYm9vbCxcbiAgZmlsdGVyYWJsZTogUHJvcFR5cGVzLmJvb2wsXG4gIGRlZmF1bHRTb3J0RGVzYzogUHJvcFR5cGVzLmJvb2wsXG4gIGRlZmF1bHRTb3J0ZWQ6IFByb3BUeXBlcy5hcnJheSxcbiAgZGVmYXVsdEZpbHRlcmVkOiBQcm9wVHlwZXMuYXJyYXksXG4gIGRlZmF1bHRSZXNpemVkOiBQcm9wVHlwZXMuYXJyYXksXG4gIGRlZmF1bHRFeHBhbmRlZDogUHJvcFR5cGVzLm9iamVjdCxcbiAgZGVmYXVsdEZpbHRlck1ldGhvZDogUHJvcFR5cGVzLmZ1bmMsXG4gIGRlZmF1bHRTb3J0TWV0aG9kOiBQcm9wVHlwZXMuZnVuYyxcblxuICAvLyBDb250cm9sbGVkIFN0YXRlIENhbGxiYWNrc1xuICBvblBhZ2VDaGFuZ2U6IFByb3BUeXBlcy5mdW5jLFxuICBvblBhZ2VTaXplQ2hhbmdlOiBQcm9wVHlwZXMuZnVuYyxcbiAgb25Tb3J0ZWRDaGFuZ2U6IFByb3BUeXBlcy5mdW5jLFxuICBvbkZpbHRlcmVkQ2hhbmdlOiBQcm9wVHlwZXMuZnVuYyxcbiAgb25SZXNpemVkQ2hhbmdlOiBQcm9wVHlwZXMuZnVuYyxcbiAgb25FeHBhbmRlZENoYW5nZTogUHJvcFR5cGVzLmZ1bmMsXG5cbiAgLy8gUGl2b3RpbmdcbiAgcGl2b3RCeTogUHJvcFR5cGVzLmFycmF5LFxuXG4gIC8vIEtleSBDb25zdGFudHNcbiAgcGl2b3RWYWxLZXk6IFByb3BUeXBlcy5zdHJpbmcsXG4gIHBpdm90SURLZXk6IFByb3BUeXBlcy5zdHJpbmcsXG4gIHN1YlJvd3NLZXk6IFByb3BUeXBlcy5zdHJpbmcsXG4gIGFnZ3JlZ2F0ZWRLZXk6IFByb3BUeXBlcy5zdHJpbmcsXG4gIG5lc3RpbmdMZXZlbEtleTogUHJvcFR5cGVzLnN0cmluZyxcbiAgb3JpZ2luYWxLZXk6IFByb3BUeXBlcy5zdHJpbmcsXG4gIGluZGV4S2V5OiBQcm9wVHlwZXMuc3RyaW5nLFxuICBncm91cGVkQnlQaXZvdEtleTogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvLyBTZXJ2ZXItc2lkZSBDYWxsYmFja3NcbiAgb25GZXRjaERhdGE6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8vIENsYXNzZXNcbiAgY2xhc3NOYW1lOiBQcm9wVHlwZXMuc3RyaW5nLFxuICBzdHlsZTogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvLyBDb21wb25lbnQgZGVjb3JhdG9yc1xuICBnZXRQcm9wczogUHJvcFR5cGVzLmZ1bmMsXG4gIGdldFRhYmxlUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuICBnZXRUaGVhZEdyb3VwUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuICBnZXRUaGVhZEdyb3VwVHJQcm9wczogUHJvcFR5cGVzLmZ1bmMsXG4gIGdldFRoZWFkR3JvdXBUaFByb3BzOiBQcm9wVHlwZXMuZnVuYyxcbiAgZ2V0VGhlYWRQcm9wczogUHJvcFR5cGVzLmZ1bmMsXG4gIGdldFRoZWFkVHJQcm9wczogUHJvcFR5cGVzLmZ1bmMsXG4gIGdldFRoZWFkVGhQcm9wczogUHJvcFR5cGVzLmZ1bmMsXG4gIGdldFRoZWFkRmlsdGVyUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuICBnZXRUaGVhZEZpbHRlclRyUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuICBnZXRUaGVhZEZpbHRlclRoUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuICBnZXRUYm9keVByb3BzOiBQcm9wVHlwZXMuZnVuYyxcbiAgZ2V0VHJHcm91cFByb3BzOiBQcm9wVHlwZXMuZnVuYyxcbiAgZ2V0VHJQcm9wczogUHJvcFR5cGVzLmZ1bmMsXG4gIGdldFRkUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuICBnZXRUZm9vdFByb3BzOiBQcm9wVHlwZXMuZnVuYyxcbiAgZ2V0VGZvb3RUclByb3BzOiBQcm9wVHlwZXMuZnVuYyxcbiAgZ2V0VGZvb3RUZFByb3BzOiBQcm9wVHlwZXMuZnVuYyxcbiAgZ2V0UGFnaW5hdGlvblByb3BzOiBQcm9wVHlwZXMuZnVuYyxcbiAgZ2V0TG9hZGluZ1Byb3BzOiBQcm9wVHlwZXMuZnVuYyxcbiAgZ2V0Tm9EYXRhUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuICBnZXRSZXNpemVyUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuXG4gIC8vIEdsb2JhbCBDb2x1bW4gRGVmYXVsdHNcbiAgY29sdW1uczogUHJvcFR5cGVzLmFycmF5T2YoXG4gICAgUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIC8vIFJlbmRlcmVyc1xuICAgICAgQ2VsbDogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgICAgIFByb3BUeXBlcy5lbGVtZW50LFxuICAgICAgICBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICBQcm9wVHlwZXMuZnVuYyxcbiAgICAgIF0pLFxuICAgICAgSGVhZGVyOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICAgICAgUHJvcFR5cGVzLmVsZW1lbnQsXG4gICAgICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIFByb3BUeXBlcy5mdW5jLFxuICAgICAgXSksXG4gICAgICBGb290ZXI6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1xuICAgICAgICBQcm9wVHlwZXMuZWxlbWVudCxcbiAgICAgICAgUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgUHJvcFR5cGVzLmZ1bmMsXG4gICAgICBdKSxcbiAgICAgIEFnZ3JlZ2F0ZWQ6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1xuICAgICAgICBQcm9wVHlwZXMuZWxlbWVudCxcbiAgICAgICAgUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgUHJvcFR5cGVzLmZ1bmMsXG4gICAgICBdKSxcbiAgICAgIFBpdm90OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICAgICAgUHJvcFR5cGVzLmVsZW1lbnQsXG4gICAgICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIFByb3BUeXBlcy5mdW5jLFxuICAgICAgXSksXG4gICAgICBQaXZvdFZhbHVlOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICAgICAgUHJvcFR5cGVzLmVsZW1lbnQsXG4gICAgICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIFByb3BUeXBlcy5mdW5jLFxuICAgICAgXSksXG4gICAgICBFeHBhbmRlcjogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgICAgIFByb3BUeXBlcy5lbGVtZW50LFxuICAgICAgICBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICBQcm9wVHlwZXMuZnVuYyxcbiAgICAgIF0pLFxuICAgICAgRmlsdGVyOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZWxlbWVudCwgUHJvcFR5cGVzLmZ1bmNdKSxcblxuICAgICAgLy8gQWxsIENvbHVtbnNcbiAgICAgIHNvcnRhYmxlOiBQcm9wVHlwZXMuYm9vbCwgLy8gdXNlIHRhYmxlIGRlZmF1bHRcbiAgICAgIHJlc2l6YWJsZTogUHJvcFR5cGVzLmJvb2wsIC8vIHVzZSB0YWJsZSBkZWZhdWx0XG4gICAgICBmaWx0ZXJhYmxlOiBQcm9wVHlwZXMuYm9vbCwgLy8gdXNlIHRhYmxlIGRlZmF1bHRcbiAgICAgIHNob3c6IFByb3BUeXBlcy5ib29sLFxuICAgICAgbWluV2lkdGg6IFByb3BUeXBlcy5udW1iZXIsXG5cbiAgICAgIC8vIENlbGxzIG9ubHlcbiAgICAgIGNsYXNzTmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgIHN0eWxlOiBQcm9wVHlwZXMub2JqZWN0LFxuICAgICAgZ2V0UHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuXG4gICAgICAvLyBQaXZvdCBvbmx5XG4gICAgICBhZ2dyZWdhdGU6IFByb3BUeXBlcy5mdW5jLFxuXG4gICAgICAvLyBIZWFkZXJzIG9ubHlcbiAgICAgIGhlYWRlckNsYXNzTmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgIGhlYWRlclN0eWxlOiBQcm9wVHlwZXMub2JqZWN0LFxuICAgICAgZ2V0SGVhZGVyUHJvcHM6IFByb3BUeXBlcy5mdW5jLFxuXG4gICAgICAvLyBGb290ZXJzIG9ubHlcbiAgICAgIGZvb3RlckNsYXNzTmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgIGZvb3RlclN0eWxlOiBQcm9wVHlwZXMub2JqZWN0LFxuICAgICAgZ2V0Rm9vdGVyUHJvcHM6IFByb3BUeXBlcy5vYmplY3QsXG4gICAgICBmaWx0ZXJNZXRob2Q6IFByb3BUeXBlcy5mdW5jLFxuICAgICAgZmlsdGVyQWxsOiBQcm9wVHlwZXMuYm9vbCxcbiAgICAgIHNvcnRNZXRob2Q6IFByb3BUeXBlcy5mdW5jLFxuICAgIH0pLFxuICApLFxuXG4gIC8vIEdsb2JhbCBFeHBhbmRlciBDb2x1bW4gRGVmYXVsdHNcbiAgZXhwYW5kZXJEZWZhdWx0czogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICBzb3J0YWJsZTogUHJvcFR5cGVzLmJvb2wsXG4gICAgcmVzaXphYmxlOiBQcm9wVHlwZXMuYm9vbCxcbiAgICBmaWx0ZXJhYmxlOiBQcm9wVHlwZXMuYm9vbCxcbiAgICB3aWR0aDogUHJvcFR5cGVzLm51bWJlcixcbiAgfSksXG5cbiAgcGl2b3REZWZhdWx0czogUHJvcFR5cGVzLm9iamVjdCxcblxuICAvLyBUZXh0XG4gIHByZXZpb3VzVGV4dDogUHJvcFR5cGVzLm5vZGUsXG4gIG5leHRUZXh0OiBQcm9wVHlwZXMubm9kZSxcbiAgbG9hZGluZ1RleHQ6IFByb3BUeXBlcy5ub2RlLFxuICBub0RhdGFUZXh0OiBQcm9wVHlwZXMubm9kZSxcbiAgcGFnZVRleHQ6IFByb3BUeXBlcy5ub2RlLFxuICBvZlRleHQ6IFByb3BUeXBlcy5ub2RlLFxuICByb3dzVGV4dDogUHJvcFR5cGVzLm5vZGUsXG5cbiAgLy8gQ29tcG9uZW50c1xuICBUYWJsZUNvbXBvbmVudDogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLmZ1bmMsIFByb3BUeXBlcy5lbGVtZW50XSksXG4gIFRoZWFkQ29tcG9uZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZnVuYywgUHJvcFR5cGVzLmVsZW1lbnRdKSxcbiAgVGJvZHlDb21wb25lbnQ6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5mdW5jLCBQcm9wVHlwZXMuZWxlbWVudF0pLFxuICBUckdyb3VwQ29tcG9uZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZnVuYywgUHJvcFR5cGVzLmVsZW1lbnRdKSxcbiAgVHJDb21wb25lbnQ6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5mdW5jLCBQcm9wVHlwZXMuZWxlbWVudF0pLFxuICBUaENvbXBvbmVudDogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLmZ1bmMsIFByb3BUeXBlcy5lbGVtZW50XSksXG4gIFRkQ29tcG9uZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZnVuYywgUHJvcFR5cGVzLmVsZW1lbnRdKSxcbiAgVGZvb3RDb21wb25lbnQ6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5mdW5jLCBQcm9wVHlwZXMuZWxlbWVudF0pLFxuICBGaWx0ZXJDb21wb25lbnQ6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5mdW5jLCBQcm9wVHlwZXMuZWxlbWVudF0pLFxuICBFeHBhbmRlckNvbXBvbmVudDogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLmZ1bmMsIFByb3BUeXBlcy5lbGVtZW50XSksXG4gIFBpdm90VmFsdWVDb21wb25lbnQ6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5mdW5jLCBQcm9wVHlwZXMuZWxlbWVudF0pLFxuICBBZ2dyZWdhdGVkQ29tcG9uZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZnVuYywgUHJvcFR5cGVzLmVsZW1lbnRdKSxcbiAgLy8gdGhpcyBpcyBhIGNvbXB1dGVkIGRlZmF1bHQgZ2VuZXJhdGVkIHVzaW5nXG4gIFBpdm90Q29tcG9uZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZnVuYywgUHJvcFR5cGVzLmVsZW1lbnRdKSxcbiAgLy8gdGhlIEV4cGFuZGVyQ29tcG9uZW50IGFuZCBQaXZvdFZhbHVlQ29tcG9uZW50IGF0IHJ1bi10aW1lIGluIG1ldGhvZHMuanNcbiAgUGFnaW5hdGlvbkNvbXBvbmVudDogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLmZ1bmMsIFByb3BUeXBlcy5lbGVtZW50XSksXG4gIFByZXZpb3VzQ29tcG9uZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZnVuYywgUHJvcFR5cGVzLmVsZW1lbnRdKSxcbiAgTmV4dENvbXBvbmVudDogUHJvcFR5cGVzLm9uZU9mVHlwZShbUHJvcFR5cGVzLmZ1bmMsIFByb3BUeXBlcy5lbGVtZW50XSksXG4gIExvYWRpbmdDb21wb25lbnQ6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5mdW5jLCBQcm9wVHlwZXMuZWxlbWVudF0pLFxuICBOb0RhdGFDb21wb25lbnQ6IFByb3BUeXBlcy5vbmVPZlR5cGUoW1Byb3BUeXBlcy5mdW5jLCBQcm9wVHlwZXMuZWxlbWVudF0pLFxuICBSZXNpemVyQ29tcG9uZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZnVuYywgUHJvcFR5cGVzLmVsZW1lbnRdKSxcbiAgUGFkUm93Q29tcG9uZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtQcm9wVHlwZXMuZnVuYywgUHJvcFR5cGVzLmVsZW1lbnRdKSxcbn1cbiJdfQ==