'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  // General
  data: _propTypes2.default.array,
  loading: _propTypes2.default.bool,
  showPagination: _propTypes2.default.bool,
  showPaginationTop: _propTypes2.default.bool,
  showPaginationBottom: _propTypes2.default.bool,
  showPageSizeOptions: _propTypes2.default.bool,
  pageSizeOptions: _propTypes2.default.array,
  defaultPageSize: _propTypes2.default.number,
  showPageJump: _propTypes2.default.bool,
  collapseOnSortingChange: _propTypes2.default.bool,
  collapseOnPageChange: _propTypes2.default.bool,
  collapseOnDataChange: _propTypes2.default.bool,
  freezeWhenExpanded: _propTypes2.default.bool,
  sortable: _propTypes2.default.bool,
  resizable: _propTypes2.default.bool,
  filterable: _propTypes2.default.bool,
  defaultSortDesc: _propTypes2.default.bool,
  defaultSorted: _propTypes2.default.array,
  defaultFiltered: _propTypes2.default.array,
  defaultResized: _propTypes2.default.array,
  defaultExpanded: _propTypes2.default.object,
  defaultFilterMethod: _propTypes2.default.func,
  defaultSortMethod: _propTypes2.default.func,

  // Controlled State Callbacks
  onPageChange: _propTypes2.default.func,
  onPageSizeChange: _propTypes2.default.func,
  onSortedChange: _propTypes2.default.func,
  onFilteredChange: _propTypes2.default.func,
  onResizedChange: _propTypes2.default.func,
  onExpandedChange: _propTypes2.default.func,

  // Pivoting
  pivotBy: _propTypes2.default.array,

  // Key Constants
  pivotValKey: _propTypes2.default.string,
  pivotIDKey: _propTypes2.default.string,
  subRowsKey: _propTypes2.default.string,
  aggregatedKey: _propTypes2.default.string,
  nestingLevelKey: _propTypes2.default.string,
  originalKey: _propTypes2.default.string,
  indexKey: _propTypes2.default.string,
  groupedByPivotKey: _propTypes2.default.string,

  // Server-side Callbacks
  onFetchData: _propTypes2.default.func,

  // Classes
  className: _propTypes2.default.string,
  style: _propTypes2.default.object,

  // Component decorators
  getProps: _propTypes2.default.func,
  getTableProps: _propTypes2.default.func,
  getTheadGroupProps: _propTypes2.default.func,
  getTheadGroupTrProps: _propTypes2.default.func,
  getTheadGroupThProps: _propTypes2.default.func,
  getTheadProps: _propTypes2.default.func,
  getTheadTrProps: _propTypes2.default.func,
  getTheadThProps: _propTypes2.default.func,
  getTheadFilterProps: _propTypes2.default.func,
  getTheadFilterTrProps: _propTypes2.default.func,
  getTheadFilterThProps: _propTypes2.default.func,
  getTbodyProps: _propTypes2.default.func,
  getTrGroupProps: _propTypes2.default.func,
  getTrProps: _propTypes2.default.func,
  getTdProps: _propTypes2.default.func,
  getTfootProps: _propTypes2.default.func,
  getTfootTrProps: _propTypes2.default.func,
  getTfootTdProps: _propTypes2.default.func,
  getPaginationProps: _propTypes2.default.func,
  getLoadingProps: _propTypes2.default.func,
  getNoDataProps: _propTypes2.default.func,
  getResizerProps: _propTypes2.default.func,

  // Global Column Defaults
  columns: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    // Renderers
    Cell: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Header: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Footer: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Aggregated: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Pivot: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    PivotValue: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Expander: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.func]),
    Filter: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.func]),

    // All Columns
    sortable: _propTypes2.default.bool, // use table default
    resizable: _propTypes2.default.bool, // use table default
    filterable: _propTypes2.default.bool, // use table default
    show: _propTypes2.default.bool,
    minWidth: _propTypes2.default.number,

    // Cells only
    className: _propTypes2.default.string,
    style: _propTypes2.default.object,
    getProps: _propTypes2.default.func,

    // Pivot only
    aggregate: _propTypes2.default.func,

    // Headers only
    headerClassName: _propTypes2.default.string,
    headerStyle: _propTypes2.default.object,
    getHeaderProps: _propTypes2.default.func,

    // Footers only
    footerClassName: _propTypes2.default.string,
    footerStyle: _propTypes2.default.object,
    getFooterProps: _propTypes2.default.object,
    filterMethod: _propTypes2.default.func,
    filterAll: _propTypes2.default.bool,
    sortMethod: _propTypes2.default.func
  })),

  // Global Expander Column Defaults
  expanderDefaults: _propTypes2.default.shape({
    sortable: _propTypes2.default.bool,
    resizable: _propTypes2.default.bool,
    filterable: _propTypes2.default.bool,
    width: _propTypes2.default.number
  }),

  pivotDefaults: _propTypes2.default.object,

  // Text
  previousText: _propTypes2.default.node,
  nextText: _propTypes2.default.node,
  loadingText: _propTypes2.default.node,
  noDataText: _propTypes2.default.node,
  pageText: _propTypes2.default.node,
  ofText: _propTypes2.default.node,
  rowsText: _propTypes2.default.node,

  // Components
  TableComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TheadComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TbodyComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TrGroupComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TrComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  ThComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TdComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  TfootComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  FilterComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  ExpanderComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  PivotValueComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  AggregatedComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  // this is a computed default generated using
  PivotComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  // the ExpanderComponent and PivotValueComponent at run-time in methods.js
  PaginationComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  PreviousComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  NextComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  LoadingComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  NoDataComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  ResizerComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element]),
  PadRowComponent: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.element])
};
//# sourceMappingURL=data:application/json;base64,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