'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _immutabilityHelper = require('immutability-helper');

var _immutabilityHelper2 = _interopRequireDefault(_immutabilityHelper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var commands = {
  set: function set(value) {
    return { $set: value };
  },
  push: function push(value) {
    return { $push: [value] };
  },
  splice: function splice(value) {
    return { $splice: [[value, 1]] };
  }
};

// Immutability update data using type, path, value.
/**
 * Copyright 2016-present, jianghai.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

var updateHelper = {
  getImmutabilitySugarCommand: function getImmutabilitySugarCommand(type, value) {
    return commands[type](value);
  },


  // [a, b] with 1 => {a: {b: 1}}
  getNestedData: function getNestedData(path, value) {
    var target = {};
    var lastKey = void 0;
    if (path) {
      (function () {
        var temp = target;
        if (Array.isArray(path)) {
          lastKey = path.pop();
          path.forEach(function (key) {
            temp[key] = {};
            temp = temp[key];
          });
        } else {
          lastKey = path;
        }
        temp[lastKey] = value;
      })();
    } else {
      target = value;
    }
    return target;
  },
  update: function update(source, type, path, value) {
    var command = updateHelper.getImmutabilitySugarCommand(type, value);
    var sugar = updateHelper.getNestedData(path, command);
    return (0, _immutabilityHelper2.default)(source, sugar);
  }
};

// const LAST_STATE = '__lastState'

function isPlainObject(obj) {
  return Object.prototype.toString.call(obj) === '[object Object]';
}

// 'a.b.c' => ['a', 'b', 'c']
function getPathArray(path) {
  if (typeof path === 'string') {
    path = path.split(/\.|\[|\]/).filter(function (v) {
      return !!v;
    });
  }
  return path;
}

// Destruct path with first prop and remain path.
// Such as: 'a.b.c' or ['a', 'b', 'c'] and return ['a', ['b', 'c']].
function getDestructPath(path) {
  path = getPathArray(path);
  var prop = path.shift();
  if (!path.length) path = null;
  return [prop, path];
}

function updateState() {
  var _this = this;

  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  var type = args[0];
  var path = args[1];
  var value = args[2];

  var nextState = {};

  var updateNextState = function updateNextState(type, path, value) {
    if (isPlainObject(path)) {
      // For multipe props
      (0, _keys2.default)(path).forEach(function (key) {
        updateNextState(type, key, path[key]);
      });
    } else {
      var _getDestructPath = getDestructPath(path);

      var _getDestructPath2 = (0, _slicedToArray3.default)(_getDestructPath, 2);

      var prop = _getDestructPath2[0];
      var remainPath = _getDestructPath2[1];

      if (!remainPath && type === 'set') {
        // No need to update immutably
        nextState[prop] = value;
      } else {
        nextState[prop] = updateHelper.update(_this.state[prop], type, remainPath, value);
      }
    }
  };

  updateNextState(type, path, value);
  this.setState(nextState);

  var keys = (0, _keys2.default)(nextState);
  return keys.length === 1 ? nextState[keys[0]] : nextState;
}

function updateSilent() {
  for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    args[_key2] = arguments[_key2];
  }

  var source = args[0];
  var type = args[1];
  var path = args[2];
  var value = args[3];

  return updateHelper.update(source, type, getPathArray(path), value);
}

// If you bind update to the instance of React Component, the arguments could be 
// [type, path, value] or [type, {path1: value1, path2: value2}] which was changed 
// based on the component state and execute stateState automatically. 
// Another way, if you call update purely, the argumets could be 
// [target, type, path, value], the path is not required and will not execute stateState.
// Anyway, the return value of update would be the newData, if you changed multuple 
// props, the newData would be an key-value object.
function update() {
  for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
    args[_key3] = arguments[_key3];
  }

  if (this && this.isReactComponent) {
    return updateState.apply(this, args);
  } else {
    return updateSilent.apply(undefined, args);
  }
}

exports.default = update;