"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports["default"] = createFields;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var _react = require("react");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _invariant = _interopRequireDefault(require("invariant"));

var _get = _interopRequireDefault(require("lodash/get"));

var _ConnectedFields = _interopRequireDefault(require("./ConnectedFields"));

var _shallowCompare = _interopRequireDefault(require("./util/shallowCompare"));

var _plain = _interopRequireDefault(require("./structure/plain"));

var _prefixName = _interopRequireDefault(require("./util/prefixName"));

var _ReduxFormContext = require("./ReduxFormContext");

var _validateComponentProp = _interopRequireDefault(require("./util/validateComponentProp"));

var validateNameProp = function validateNameProp(prop) {
  if (!prop) {
    return new Error('No "names" prop was specified <Fields/>');
  }

  if (!Array.isArray(prop) && !prop._isFieldArray) {
    return new Error('Invalid prop "names" supplied to <Fields/>. Must be either an array of strings or the fields array generated by FieldArray.');
  }
};

var warnAndValidatePropType = _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].arrayOf(_propTypes["default"].func), _propTypes["default"].objectOf(_propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].arrayOf(_propTypes["default"].func)]))]);

var fieldsPropTypes = {
  component: _validateComponentProp["default"],
  format: _propTypes["default"].func,
  parse: _propTypes["default"].func,
  props: _propTypes["default"].object,
  forwardRef: _propTypes["default"].bool,
  validate: warnAndValidatePropType,
  warn: warnAndValidatePropType
};

var getFieldWarnAndValidate = function getFieldWarnAndValidate(prop, name) {
  return Array.isArray(prop) || typeof prop === 'function' ? prop : (0, _get["default"])(prop, name, undefined);
};

function createFields(structure) {
  var ConnectedFields = (0, _ConnectedFields["default"])(structure);

  var Fields =
  /*#__PURE__*/
  function (_Component) {
    (0, _inheritsLoose2["default"])(Fields, _Component);

    function Fields(props) {
      var _this;

      _this = _Component.call(this, props) || this;

      if (!props._reduxForm) {
        throw new Error('Fields must be inside a component decorated with reduxForm()');
      }

      var error = validateNameProp(props.names);

      if (error) {
        throw error;
      }

      return _this;
    }

    var _proto = Fields.prototype;

    _proto.shouldComponentUpdate = function shouldComponentUpdate(nextProps) {
      return (0, _shallowCompare["default"])(this, nextProps);
    };

    _proto.componentDidMount = function componentDidMount() {
      this.registerFields(this.props.names);
    };

    _proto.UNSAFE_componentWillReceiveProps = function UNSAFE_componentWillReceiveProps(nextProps) {
      if (!_plain["default"].deepEqual(this.props.names, nextProps.names)) {
        var props = this.props;
        var unregister = props._reduxForm.unregister; // unregister old name

        this.props.names.forEach(function (name) {
          return unregister((0, _prefixName["default"])(props, name));
        }); // register new name

        this.registerFields(nextProps.names);
      }
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      var props = this.props;
      var unregister = props._reduxForm.unregister;
      this.props.names.forEach(function (name) {
        return unregister((0, _prefixName["default"])(props, name));
      });
    };

    _proto.registerFields = function registerFields(names) {
      var _this2 = this;

      var props = this.props;
      var register = props._reduxForm.register;
      names.forEach(function (name) {
        return register((0, _prefixName["default"])(props, name), 'Field', function () {
          return getFieldWarnAndValidate(_this2.props.validate, name);
        }, function () {
          return getFieldWarnAndValidate(_this2.props.warn, name);
        });
      });
    };

    _proto.getRenderedComponent = function getRenderedComponent() {
      (0, _invariant["default"])(this.props.forwardRef, 'If you want to access getRenderedComponent(), ' + 'you must specify a forwardRef prop to Fields');
      return this.refs.connected.getRenderedComponent();
    };

    _proto.render = function render() {
      var props = this.props;
      return (0, _react.createElement)(ConnectedFields, (0, _extends2["default"])({}, this.props, {
        names: this.props.names.map(function (name) {
          return (0, _prefixName["default"])(props, name);
        }),
        ref: 'connected'
      }));
    };

    (0, _createClass2["default"])(Fields, [{
      key: "names",
      get: function get() {
        var props = this.props;
        return this.props.names.map(function (name) {
          return (0, _prefixName["default"])(props, name);
        });
      }
    }, {
      key: "dirty",
      get: function get() {
        return this.refs.connected.isDirty();
      }
    }, {
      key: "pristine",
      get: function get() {
        return !this.dirty;
      }
    }, {
      key: "values",
      get: function get() {
        return this.refs.connected && this.refs.connected.getValues();
      }
    }]);
    return Fields;
  }(_react.Component);

  Fields.propTypes = (0, _extends2["default"])({
    names: function names(props, propName) {
      return validateNameProp(props[propName]);
    }
  }, fieldsPropTypes);
  return (0, _ReduxFormContext.withReduxForm)(Fields);
}