"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.iconRenderer = iconRenderer;

var _iconRendererEmoji = require("./icon-renderer-emoji");

var _iconRendererSvgInline = require("./icon-renderer-svg-inline");

function iconRenderer(renderer) {
  switch (renderer) {
    case 'emoji':
      return _iconRendererEmoji.emojiIconRenderer;

    case 'svg-inline':
      return _iconRendererSvgInline.svgInlineIconRenderer;

    default:
      throw new Error(`Icon Renderer "${renderer}" is not defined.`);
  }
}