"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _tokens = require("./tokens");

var _parser = require("./parser");

var _renderer = require("./renderer");

/**
 * Remarkable plugin that recognizes callout syntax in markdown and renders
 * it in a dedicated paragraph.
 *
 * Example syntax:
 *
 *    :::info
 *    This is an information callout
 *    :::
 *
 * @todo Add opts to customize rendering.
 */
const plugin = admonitionOpts => (md, opts) => {
  const mergedOpts = {
    icon: 'emoji',
    ...admonitionOpts
  };
  md.block.ruler.before('code', _tokens.TOKENS.CALLOUT, _parser.parser, opts);
  md.renderer.rules[_tokens.TOKENS.CALLOUT_OPEN] = (0, _renderer.openRenderer)(mergedOpts);
  md.renderer.rules[_tokens.TOKENS.CALLOUT_CLOSE] = (0, _renderer.closeRenderer)(mergedOpts);
};

var _default = plugin;
exports.default = _default;
module.exports = exports.default;