"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openRenderer = openRenderer;
exports.closeRenderer = closeRenderer;

var _iconRenderer = require("./icon-renderers/icon-renderer");

/**
 * Remarkable admonition renderer.
 */
function openRenderer(admonitionOpts) {
  return (tokens, idx, options, env) => {
    const renderIcon = (0, _iconRenderer.iconRenderer)(admonitionOpts.icon);
    const token = tokens[idx];
    const icon = renderIcon.content(token.admonition);
    const iconTemplate = `<div class="admonition-icon">${icon || ''}</div>`;
    return `
    <div class="admonition admonition-${token.admonition}">
      <div class="admonition-heading">
        <h5>${iconTemplate} ${token.title || token.admonition}</h5>
      </div>
      <div class="admonition-content">
    `;
  };
}
/**
 * Callout closing tag renderer
 */


function closeRenderer(admonitionOpts) {
  return (tokens, idx, options, env) => {
    return `</div></div>`;
  };
}