/// <reference types="node" />
import { Readable } from "stream";
export declare type ExtractCallback = (dataStream: Readable) => Promise<string | Buffer>;
export declare type FileNameAndContent = Record<string, string | Buffer>;
export interface ExtractionResult {
    imageId: string;
    manifestLayers: string[];
    extractedLayers: ExtractedLayers;
}
export interface ExtractedLayers {
    [layerName: string]: FileNameAndContent;
}
export interface ExtractedLayersAndManifest {
    layers: ExtractedLayers[];
    manifest: DockerArchiveManifest;
}
export interface DockerArchiveManifest {
    Config: string;
    RepoTags: string[];
    Layers: string[];
}
export interface OciArchiveLayer {
    digest: string;
}
export interface OciArchiveManifest {
    schemaVersion: string;
    config: {
        digest: string;
    };
    layers: OciArchiveLayer[];
}
export interface OciManifestInfo {
    digest: string;
    platform?: {
        architecture: string;
        os: string;
    };
}
export interface OciImageIndex {
    manifests: OciManifestInfo[];
}
export interface ExtractAction {
    actionName: string;
    filePathMatches: (filePath: string) => boolean;
    callback?: ExtractCallback;
}
