"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("./types");
function getImageType(targetImage) {
    const imageIdentifier = targetImage.split(":")[0];
    switch (imageIdentifier) {
        case "docker-archive":
            return types_1.ImageType.DockerArchive;
        case "oci-archive":
            return types_1.ImageType.OciArchive;
        default:
            return types_1.ImageType.Identifier;
    }
}
exports.getImageType = getImageType;
function getArchivePath(targetImage) {
    // strip the "docker-archive:" or "oci-archive:" prefix
    const path = targetImage.split(":")[1];
    if (!path) {
        throw new Error('The provided archive path is missing image specific prefix, eg."docker-archive:" or "oci-archive:"');
    }
    return path;
}
exports.getArchivePath = getArchivePath;
//# sourceMappingURL=image-type.js.map