"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const types_1 = require("../../../analyzer/types");
function analyze(targetImage, installedPackages, pkgManager, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const binaries = yield getBinaries(targetImage, installedPackages, pkgManager, options);
        return {
            Image: targetImage,
            AnalyzeType: types_1.AnalysisType.Binaries,
            Analysis: binaries,
        };
    });
}
exports.analyze = analyze;
const binaryVersionExtractors = {
    node: require("./node"),
    openjdk: require("./openjdk-jre"),
};
function getBinaries(targetImage, installedPackages, pkgManager, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const binaries = [];
        for (const versionExtractor of Object.keys(binaryVersionExtractors)) {
            const extractor = binaryVersionExtractors[versionExtractor];
            if (extractor.installedByPackageManager(installedPackages, pkgManager, options)) {
                continue;
            }
            const binary = yield extractor.extract(targetImage, options);
            if (binary) {
                binaries.push(binary);
            }
        }
        return binaries;
    });
}
//# sourceMappingURL=index.js.map