"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const analyzer = require("./analyzer");
const dependency_tree_1 = require("./dependency-tree");
const errors_1 = require("./errors");
const parser_1 = require("./parser");
const response_builder_1 = require("./response-builder");
function analyzeStatically(targetImage, dockerfileAnalysis, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const staticAnalysisOptions = getStaticAnalysisOptions(options);
        // Relevant only if using a Docker runtime. Optional, but we may consider what to put here
        // to present to the user in Snyk UI.
        const runtime = undefined;
        try {
            const staticAnalysis = yield analyzer.analyzeStatically(targetImage, dockerfileAnalysis, staticAnalysisOptions);
            const parsedAnalysisResult = parser_1.parseAnalysisResults(targetImage, staticAnalysis);
            const dependenciesTree = yield dependency_tree_1.buildTree(targetImage, parsedAnalysisResult.type, parsedAnalysisResult.depInfosList, parsedAnalysisResult.targetOS);
            const analysis = {
                package: dependenciesTree,
                packageManager: parsedAnalysisResult.type,
                imageId: parsedAnalysisResult.imageId,
                binaries: parsedAnalysisResult.binaries,
                imageLayers: parsedAnalysisResult.imageLayers,
                applicationDependenciesScanResults: staticAnalysis.applicationDependenciesScanResults,
            };
            // hacking our way through types for backwards compatibility
            const response = Object.assign(Object.assign({}, response_builder_1.buildResponse(runtime, analysis, dockerfileAnalysis, staticAnalysis.manifestFiles, staticAnalysisOptions)), { hashes: [] });
            response.hashes = staticAnalysis.binaries;
            return response;
        }
        catch (error) {
            const analysisError = errors_1.tryGetAnalysisError(error, targetImage);
            throw analysisError;
        }
    });
}
exports.analyzeStatically = analyzeStatically;
function isRequestingStaticAnalysis(options) {
    return options && options.staticAnalysisOptions;
}
exports.isRequestingStaticAnalysis = isRequestingStaticAnalysis;
// TODO: this function needs to go as soon as the dynamic scanning goes
function getStaticAnalysisOptions(options) {
    if (!options ||
        !options.staticAnalysisOptions ||
        !options.staticAnalysisOptions.imagePath ||
        options.staticAnalysisOptions.imageType === undefined) {
        throw new Error("Missing required parameters for static analysis");
    }
    return {
        imagePath: options.staticAnalysisOptions.imagePath,
        imageType: options.staticAnalysisOptions.imageType,
        distroless: options.staticAnalysisOptions.distroless,
        appScan: options.staticAnalysisOptions.appScan,
        globsToFind: {
            include: options.manifestGlobs,
            exclude: options.manifestExcludeGlobs,
        },
    };
}
//# sourceMappingURL=static.js.map