"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const crypto = require("crypto");
const HASH_ALGORITHM = "sha256"; // TODO algorithm?
const HASH_ENCODING = "hex";
function streamToString(stream, encoding = "utf8") {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const chunks = [];
        return new Promise((resolve, reject) => {
            stream.on("end", () => {
                resolve(chunks.join(""));
            });
            stream.on("error", (error) => reject(error));
            stream.on("data", (chunk) => {
                chunks.push(chunk.toString(encoding));
            });
        });
    });
}
exports.streamToString = streamToString;
function streamToBuffer(stream) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const chunks = [];
        return new Promise((resolve, reject) => {
            stream.on("end", () => {
                resolve(Buffer.concat(chunks));
            });
            stream.on("error", (error) => reject(error));
            stream.on("data", (chunk) => {
                chunks.push(Buffer.from(chunk));
            });
        });
    });
}
exports.streamToBuffer = streamToBuffer;
function streamToHash(stream) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return new Promise((resolve, reject) => {
            const hash = crypto.createHash(HASH_ALGORITHM);
            hash.setEncoding(HASH_ENCODING);
            stream.on("end", () => {
                hash.end();
                resolve(hash.read());
            });
            stream.on("error", (error) => reject(error));
            stream.pipe(hash);
        });
    });
}
exports.streamToHash = streamToHash;
function streamToJson(stream) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const file = yield streamToString(stream);
        return JSON.parse(file);
    });
}
exports.streamToJson = streamToJson;
//# sourceMappingURL=stream-utils.js.map