import { DockerPullResult } from "@snyk/snyk-docker-pull";
import * as subProcess from "./sub-process";
export { Docker, DockerOptions };
interface DockerOptions {
    host?: string;
    tlsVerify?: string;
    tlsCert?: string;
    tlsCaCert?: string;
    tlsKey?: string;
    socketPath?: string;
}
declare class Docker {
    private targetImage;
    static binaryExists(): Promise<boolean>;
    static run(args: string[], options?: DockerOptions): Promise<subProcess.CmdOutput>;
    private static createOptionsList;
    private optionsList;
    private socketPath;
    constructor(targetImage: string, options?: DockerOptions);
    /**
     * Runs the command, catching any expected errors and returning them as normal
     * stderr/stdout result.
     */
    runSafe(cmd: string, args?: string[], ignoreErrors?: string[]): Promise<{
        stdout: any;
        stderr: string;
    }>;
    run(cmd: string, args?: string[]): Promise<subProcess.CmdOutput>;
    pull(registry: string, repo: string, tag: string, imageSavePath: string, username?: string, password?: string): Promise<DockerPullResult>;
    pullCli(targetImage: string): Promise<subProcess.CmdOutput>;
    save(targetImage: string, destination: string): Promise<unknown>;
    inspectImage(targetImage: string): Promise<subProcess.CmdOutput>;
    catSafe(filename: string): Promise<{
        stdout: any;
        stderr: string;
    }>;
    lsSafe(path: string, recursive?: boolean): Promise<{
        stdout: any;
        stderr: string;
    }>;
    /**
     * Find files on a docker image according to a given list of glob expressions.
     */
    findGlobs(globs: string[], exclusionGlobs?: string[], path?: string, recursive?: boolean, excludeRootDirectories?: string[]): Promise<string[]>;
}
