"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("../analyzer/types");
function parseAnalysisResults(targetImage, analysis) {
    let analysisResult = analysis.results.filter((res) => {
        return res.Analysis && res.Analysis.length > 0;
    })[0];
    if (!analysisResult) {
        // Special case when we have no package management
        // on scratch images or images with unknown package manager
        analysisResult = {
            Image: targetImage,
            AnalyzeType: types_1.AnalysisType.Linux,
            Analysis: [],
        };
    }
    let depType;
    switch (analysisResult.AnalyzeType) {
        case types_1.AnalysisType.Apt: {
            depType = "deb";
            break;
        }
        default: {
            depType = analysisResult.AnalyzeType.toLowerCase();
        }
    }
    // in the dynamic scanning flow,
    // analysis.binaries is expected to be of ImageAnalysis type.
    // in this case, we want its Analysis part which should be Binary[]
    // in the static scanning flow,
    // analysis.binaries is a string[]
    // in this case, we return `undefined` and set hashes later
    let binaries;
    if (analysis && analysis.binaries && !Array.isArray(analysis.binaries)) {
        binaries = analysis.binaries.Analysis;
    }
    return {
        imageId: analysis.imageId,
        platform: analysis.platform,
        targetOS: analysis.osRelease,
        type: depType,
        depInfosList: analysisResult.Analysis,
        binaries,
        imageLayers: analysis.imageLayers,
    };
}
exports.parseAnalysisResults = parseAnalysisResults;
//# sourceMappingURL=index.js.map