/// <reference types="node" />
import { PkgTree } from "snyk-nodejs-lockfile-parser";
export interface StaticAnalysisOptions {
    imagePath: string;
    imageType: ImageType;
    distroless: boolean;
    appScan: boolean;
    globsToFind: {
        include: string[];
        exclude: string[];
    };
}
export declare enum ImageType {
    Identifier = 0,
    DockerArchive = "docker-archive",
    OciArchive = "oci-archive"
}
export declare enum OsReleaseFilePath {
    Linux = "/etc/os-release",
    LinuxFallback = "/usr/lib/os-release",
    Lsb = "/etc/lsb-release",
    Debian = "/etc/debian_version",
    Alpine = "/etc/alpine-release",
    RedHat = "/etc/redhat-release",
    Oracle = "/etc/oracle-release",
    Centos = "/etc/centos-release"
}
export interface ManifestFile {
    name: string;
    path: string;
    contents: Buffer;
}
export interface PluginMetadata {
    name: string;
    runtime: string | undefined;
    packageManager: any;
    dockerImageId: string;
    imageLayers: string[];
    rootFs?: string[];
}
export interface PluginResponseStatic extends PluginResponse {
    hashes: string[];
}
export interface PluginResponse {
    plugin: PluginMetadata;
    scannedProjects: ScannedProjectCustom[];
}
export interface ScannedProjectCustom {
    packageManager: string;
    /**
     * Using "| PkgTree" here to be truthful to the type system.
     * For application dependencies scans we use a parser which has more optional fields than the DepTree.
     * We have different required and optional fields for OS scans and application dependencies scans, so
     * a future change should be mindful but find a way to unify them if possible.
     */
    depTree: DepTree | PkgTree;
    targetFile?: string;
    meta?: any;
}
export declare enum ScanType {
    DependencyTree = "DependencyTree",
    DependencyGraph = "DependencyGraph",
    ManifestFiles = "ManifestFiles"
}
export interface ScannedProjectExtended extends ScannedProjectCustom {
    scanType: ScanType;
    data: unknown;
}
export interface ScannedProjectManifestFiles extends ScannedProjectExtended {
    scanType: ScanType.ManifestFiles;
    data: ManifestFile[];
}
export interface DepTreeDep {
    name: string;
    version: string;
    dependencies: {
        [depName: string]: DepTreeDep;
    };
    labels?: {
        [key: string]: string;
    };
}
export interface DepTree extends DepTreeDep {
    type?: string;
    packageFormatVersion: string;
    targetOS: {
        name: string;
        prettyName: string;
        version: string;
    };
    targetFile?: string;
    policy?: string;
    docker: {
        [key: string]: any;
    };
    files?: any;
}
