"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPomContents = void 0;
/**
 * Get pom.xml file contents.
 *
 * @param dependencies array of maven dependencies.
 * @param root root maven dependency.
 */
function getPomContents(dependencies, root) {
    // the awkward indentation here is important to retain final xml formatting
    const deps = dependencies.reduce((acc, dep) => {
        acc += `
    <dependency>
      <groupId>${dep.groupId}</groupId>
      <artifactId>${dep.artifactId}</artifactId>
      <version>${dep.version}</version>
    </dependency>`;
        return acc;
    }, '');
    return `<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
  <modelVersion>4.0.0</modelVersion>
  <groupId>${root.groupId}</groupId>
  <artifactId>${root.artifactId}</artifactId>
  <packaging>jar</packaging>
  <version>${root.version}</version>
  <dependencies>${deps}
  </dependencies>
</project>
`;
}
exports.getPomContents = getPomContents;
//# sourceMappingURL=pom.js.map