"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const errors_1 = require("../errors");
var Scope;
(function (Scope) {
    Scope["prod"] = "prod";
    Scope["dev"] = "dev";
})(Scope = exports.Scope || (exports.Scope = {}));
var LockfileType;
(function (LockfileType) {
    LockfileType["npm"] = "npm";
    LockfileType["yarn"] = "yarn";
    LockfileType["yarn2"] = "yarn2";
})(LockfileType = exports.LockfileType || (exports.LockfileType = {}));
function parseManifestFile(manifestFileContents) {
    try {
        return JSON.parse(manifestFileContents);
    }
    catch (e) {
        throw new errors_1.InvalidUserInputError('package.json parsing failed with error ' + e.message);
    }
}
exports.parseManifestFile = parseManifestFile;
function getTopLevelDeps(targetFile, includeDev) {
    const dependencies = [];
    const dependenciesIterator = Object.entries(Object.assign(Object.assign({}, targetFile.dependencies), (includeDev ? targetFile.devDependencies : null)));
    for (const [name, version] of dependenciesIterator) {
        dependencies.push({
            dev: includeDev && targetFile.devDependencies
                ? !!targetFile.devDependencies[name]
                : false,
            name,
            version,
        });
    }
    return dependencies;
}
exports.getTopLevelDeps = getTopLevelDeps;
function createDepTreeDepFromDep(dep) {
    return {
        labels: {
            scope: dep.dev ? Scope.dev : Scope.prod,
        },
        name: dep.name,
        version: dep.version,
    };
}
exports.createDepTreeDepFromDep = createDepTreeDepFromDep;
function getYarnWorkspaces(targetFile) {
    try {
        const packageJson = parseManifestFile(targetFile);
        if (!!packageJson.workspaces && !!packageJson.private) {
            const workspacesPackages = packageJson.workspaces;
            const workspacesAlternateConfigPackages = packageJson.workspaces
                .packages;
            return [...(workspacesAlternateConfigPackages || workspacesPackages)];
        }
        return false;
    }
    catch (e) {
        throw new errors_1.InvalidUserInputError('package.json parsing failed with ' + `error ${e.message}`);
    }
}
exports.getYarnWorkspaces = getYarnWorkspaces;
//# sourceMappingURL=index.js.map