"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const yaml = require("yaml");
const _1 = require("./");
const get_node_runtime_version_1 = require("../get-node-runtime-version");
const errors_1 = require("../errors");
const yarn_lock_parse_base_1 = require("./yarn-lock-parse-base");
const yarn_utils_1 = require("./yarn-utils");
class Yarn2LockParser extends yarn_lock_parse_base_1.YarnLockParseBase {
    constructor() {
        super(_1.LockfileType.yarn2);
        // @yarnpkg/core doesn't work with Node.js < 10
        if (get_node_runtime_version_1.default() < 10) {
            throw new errors_1.UnsupportedRuntimeError(`yarn.lock parsing is supported for Node.js v10 and higher.`);
        }
        const structUtils = require('@yarnpkg/core').structUtils;
        const parseDescriptor = structUtils.parseDescriptor;
        const parseRange = structUtils.parseRange;
        this.keyNormalizer = yarn_utils_1.yarnLockFileKeyNormalizer(parseDescriptor, parseRange);
    }
    parseLockFile(lockFileContents) {
        try {
            const rawYarnLock = yaml.parse(lockFileContents);
            delete rawYarnLock.__metadata;
            const dependencies = {};
            Object.entries(rawYarnLock).forEach(([fullDescriptor, versionData]) => {
                this.keyNormalizer(fullDescriptor).forEach((descriptor) => {
                    dependencies[descriptor] = versionData;
                });
            });
            return {
                dependencies,
                lockfileType: _1.LockfileType.yarn2,
                object: dependencies,
                type: _1.LockfileType.yarn2,
            };
        }
        catch (e) {
            throw new errors_1.InvalidUserInputError(`yarn.lock parsing failed with an error: ${e.message}`);
        }
    }
}
exports.Yarn2LockParser = Yarn2LockParser;
//# sourceMappingURL=yarn2-lock-parse.js.map