"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getContainerProjectName = exports.getContainerName = exports.getContainerTargetFile = exports.isContainer = void 0;
function isContainer(scannedProject) {
    var _a, _b;
    return (_b = (_a = scannedProject.meta) === null || _a === void 0 ? void 0 : _a.imageName) === null || _b === void 0 ? void 0 : _b.length;
}
exports.isContainer = isContainer;
function getContainerTargetFile(scannedProject) {
    return scannedProject.targetFile;
}
exports.getContainerTargetFile = getContainerTargetFile;
function getContainerName(scannedProject, meta) {
    var _a, _b;
    let name = (_a = scannedProject.meta) === null || _a === void 0 ? void 0 : _a.imageName;
    if ((_b = meta['project-name']) === null || _b === void 0 ? void 0 : _b.length) {
        name = meta['project-name'];
    }
    if (scannedProject.targetFile) {
        // for app+os projects the name of project is a mix of the image name
        // with the target file (if one exists)
        return name + ':' + scannedProject.targetFile;
    }
    else {
        return name;
    }
}
exports.getContainerName = getContainerName;
function getContainerProjectName(scannedProject, meta) {
    var _a, _b;
    let name = (_a = scannedProject.meta) === null || _a === void 0 ? void 0 : _a.imageName;
    if ((_b = meta['project-name']) === null || _b === void 0 ? void 0 : _b.length) {
        name = meta['project-name'];
    }
    return name;
}
exports.getContainerProjectName = getContainerProjectName;
//# sourceMappingURL=index.js.map