"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parse = void 0;
const path = require("path");
const fs = require("fs");
const resolveNodeDeps = require("snyk-resolve-deps");
const spinner = require("../../spinner");
const analytics = require("../../analytics");
async function parse(root, targetFile, options) {
    const nodeModulesPath = path.join(path.dirname(path.resolve(root, targetFile)), 'node_modules');
    const packageManager = options.packageManager || 'npm';
    if (!fs.existsSync(nodeModulesPath)) {
        // throw a custom error
        throw new Error("Missing node_modules folder: we can't test " +
            `without dependencies.\nPlease run '${packageManager} install' first.`);
    }
    analytics.add('local', true);
    analytics.add('generating-node-dependency-tree', {
        lockFile: false,
        targetFile,
    });
    const resolveModuleSpinnerLabel = 'Analyzing npm dependencies for ' +
        path.dirname(path.resolve(root, targetFile));
    try {
        await spinner(resolveModuleSpinnerLabel);
        if (targetFile.endsWith('yarn.lock')) {
            options.file =
                options.file && options.file.replace('yarn.lock', 'package.json');
        }
        // package-lock.json falls back to package.json (used in wizard code)
        if (targetFile.endsWith('package-lock.json')) {
            options.file =
                options.file &&
                    options.file.replace('package-lock.json', 'package.json');
        }
        return resolveNodeDeps(root, Object.assign({}, options, { noFromArrays: true }));
    }
    finally {
        await spinner.clear(resolveModuleSpinnerLabel)();
    }
}
exports.parse = parse;
//# sourceMappingURL=npm-modules-parser.js.map