"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isStandaloneBuild = exports.getVersion = void 0;
const fs = require("fs");
const path = require("path");
const exec_1 = require("./exec");
const root = path.resolve(__dirname, '../..');
function getVersion() {
    return new Promise((resolve) => {
        const filename = path.resolve(root, 'package.json');
        const version = require(filename).version;
        if (version && version !== '0.0.0') {
            return resolve(version);
        }
        // else we're in development, give the commit out
        // get the last commit and whether the working dir is dirty
        const promises = [branch(), commit(), dirty()];
        resolve(getBranchCommitAndDirty(promises));
    });
}
exports.getVersion = getVersion;
function isStandaloneBuild() {
    const standalonePath = path.join(__dirname, '../', 'STANDALONE');
    return fs.existsSync(standalonePath);
}
exports.isStandaloneBuild = isStandaloneBuild;
async function getBranchCommitAndDirty(promises) {
    try {
        const res = await Promise.all(promises);
        const branchName = res[0];
        const commitStr = res[1];
        const filesCount = res[2];
        const dirtyCount = parseInt(filesCount, 10) || 0;
        let curr = branchName + ': ' + commitStr;
        if (dirtyCount !== 0) {
            curr += ' (' + dirtyCount + ' dirty files)';
        }
        return curr;
    }
    catch (_a) {
        // handle any point where the git based lookup fails
        return 'unknown';
    }
}
const commit = () => exec_1.executeCommand('git rev-parse HEAD', root);
const branch = () => exec_1.executeCommand('git rev-parse --abbrev-ref HEAD', root);
const dirty = () => exec_1.executeCommand('git diff --shortstat', root);
//# sourceMappingURL=version.js.map