"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dockerRemediationForDisplay = void 0;
const chalk_1 = require("chalk");
function dockerRemediationForDisplay(res) {
    if (!res.docker || !res.docker.baseImageRemediation) {
        return '';
    }
    const { advice, message } = res.docker.baseImageRemediation;
    const out = [];
    if (advice) {
        for (const item of advice) {
            out.push(getTerminalStringFormatter(item)(item.message));
        }
    }
    else if (message) {
        out.push(message);
    }
    else {
        return '';
    }
    return `\n\n${out.join('\n')}`;
}
exports.dockerRemediationForDisplay = dockerRemediationForDisplay;
function getTerminalStringFormatter({ color, bold, }) {
    let formatter = chalk_1.default;
    if (color && formatter[color]) {
        formatter = formatter[color];
    }
    if (bold) {
        formatter = formatter.bold;
    }
    return formatter;
}
//# sourceMappingURL=format-docker-advice.js.map