"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gatherSpecs = exports.canHandle = void 0;
const path = require("path");
const try_get_spec_1 = require("./try-get-spec");
const pattern = /^Gemfile(\.lock)*$/;
function canHandle(file) {
    return !!file && pattern.test(path.basename(file));
}
exports.canHandle = canHandle;
async function gatherSpecs(root, target) {
    const targetName = path.basename(target);
    const targetDir = path.dirname(target);
    const files = {};
    const gemfileLock = await try_get_spec_1.tryGetSpec(root, path.join(targetDir, 'Gemfile.lock'));
    if (gemfileLock) {
        files.gemfileLock = gemfileLock;
    }
    else {
        throw new Error("Missing Gemfile.lock file: we can't test " +
            'without dependencies.\nPlease run `bundle install` first.');
    }
    const gemfile = await try_get_spec_1.tryGetSpec(root, path.join(targetDir, 'Gemfile'));
    if (gemfile) {
        files.gemfile = gemfile;
    }
    return {
        packageName: path.basename(root),
        targetFile: path.join(targetDir, targetName),
        files,
    };
}
exports.gatherSpecs = gatherSpecs;
//# sourceMappingURL=gemfile.js.map