"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestCommandResult = exports.CommandResult = void 0;
class CommandResult {
    constructor(result) {
        this.result = result;
    }
    toString() {
        return this.result;
    }
    getDisplayResults() {
        return this.result;
    }
}
exports.CommandResult = CommandResult;
class TestCommandResult extends CommandResult {
    constructor() {
        super(...arguments);
        this.jsonResult = '';
    }
    getJsonResult() {
        return this.jsonResult;
    }
    static createHumanReadableTestCommandResult(humanReadableResult, jsonResult) {
        return new HumanReadableTestCommandResult(humanReadableResult, jsonResult);
    }
    static createJsonTestCommandResult(jsonResult) {
        return new JsonTestCommandResult(jsonResult);
    }
}
exports.TestCommandResult = TestCommandResult;
class HumanReadableTestCommandResult extends TestCommandResult {
    constructor(humanReadableResult, jsonResult) {
        super(humanReadableResult);
        this.jsonResult = '';
        this.jsonResult = jsonResult;
    }
    getJsonResult() {
        return this.jsonResult;
    }
}
class JsonTestCommandResult extends TestCommandResult {
    constructor(jsonResult) {
        super(jsonResult);
    }
    getJsonResult() {
        return this.result;
    }
}
//# sourceMappingURL=types.js.map