"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inspect = void 0;
const modulesParser = require("./npm-modules-parser");
const lockParser = require("./npm-lock-parser");
const missing_targetfile_error_1 = require("../../errors/missing-targetfile-error");
async function inspect(root, targetFile, options = {}) {
    if (!targetFile) {
        throw missing_targetfile_error_1.MissingTargetFileError(root);
    }
    const isLockFileBased = targetFile.endsWith('package-lock.json') ||
        targetFile.endsWith('yarn.lock');
    const getLockFileDeps = isLockFileBased && !options.traverseNodeModules;
    const depTree = getLockFileDeps
        ? await lockParser.parse(root, targetFile, options)
        : await modulesParser.parse(root, targetFile, options);
    return {
        plugin: {
            name: 'snyk-nodejs-lockfile-parser',
            runtime: process.version,
        },
        scannedProjects: [{ depTree }],
    };
}
exports.inspect = inspect;
//# sourceMappingURL=index.js.map