"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FAIL_ON = exports.SEVERITIES = exports.assembleQueryString = void 0;
const config = require("../config");
function assembleQueryString(options) {
    const org = options.org || config.org || null;
    const qs = {
        org,
    };
    if (options.severityThreshold) {
        qs.severityThreshold = options.severityThreshold;
    }
    if (options['ignore-policy']) {
        qs.ignorePolicy = true;
    }
    return Object.keys(qs).length !== 0 ? qs : null;
}
exports.assembleQueryString = assembleQueryString;
var SEVERITY;
(function (SEVERITY) {
    SEVERITY["LOW"] = "low";
    SEVERITY["MEDIUM"] = "medium";
    SEVERITY["HIGH"] = "high";
})(SEVERITY || (SEVERITY = {}));
exports.SEVERITIES = [
    {
        verboseName: SEVERITY.LOW,
        value: 1,
    },
    {
        verboseName: SEVERITY.MEDIUM,
        value: 2,
    },
    {
        verboseName: SEVERITY.HIGH,
        value: 3,
    },
];
var FAIL_ON;
(function (FAIL_ON) {
    FAIL_ON["all"] = "all";
    FAIL_ON["upgradable"] = "upgradable";
    FAIL_ON["patchable"] = "patchable";
})(FAIL_ON = exports.FAIL_ON || (exports.FAIL_ON = {}));
//# sourceMappingURL=common.js.map