"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatMonitorOutput = void 0;
const _ = require("lodash");
const chalk_1 = require("chalk");
const url = require("url");
const config = require("../../../../lib/config");
function formatMonitorOutput(packageManager, res, options, projectName, foundProjectCount) {
    const manageUrl = buildManageUrl(res.id, res.org);
    const advertiseGradleSubProjectsCount = packageManager === 'gradle' &&
        !options['gradle-sub-project'] &&
        !options.allProjects;
    const advertiseAllProjectsCount = packageManager !== 'gradle' && !options.allProjects && foundProjectCount;
    const issues = res.licensesPolicy ? 'issues' : 'vulnerabilities';
    const humanReadableName = projectName
        ? `${res.path} (${projectName})`
        : res.path;
    const strOutput = chalk_1.default.bold.white('\nMonitoring ' + humanReadableName + '...\n\n') +
        'Explore this snapshot at ' +
        res.uri +
        '\n\n' +
        (advertiseGradleSubProjectsCount && foundProjectCount
            ? chalk_1.default.bold.white(`Tip: This project has multiple sub-projects (${foundProjectCount}), ` +
                'use --all-sub-projects flag to scan all sub-projects.\n\n')
            : '') +
        (advertiseAllProjectsCount && foundProjectCount
            ? chalk_1.default.bold.white(`Tip: Detected multiple supported manifests (${foundProjectCount}), ` +
                'use --all-projects to scan all of them at once.\n\n')
            : '') +
        (res.isMonitored
            ? 'Notifications about newly disclosed ' +
                issues +
                ' related ' +
                'to these dependencies will be emailed to you.\n'
            : chalk_1.default.bold.red('Project is inactive, so notifications are turned ' +
                'off.\nActivate this project here: ' +
                manageUrl +
                '\n\n')) +
        (res.trialStarted
            ? chalk_1.default.yellow("You're over the free plan usage limit, \n" +
                'and are now on a free 14-day premium trial.\n' +
                'View plans here: ' +
                manageUrl +
                '\n\n')
            : '');
    return options.json
        ? JSON.stringify(_.assign({}, res, {
            manageUrl,
            packageManager,
        }))
        : strOutput;
}
exports.formatMonitorOutput = formatMonitorOutput;
function buildManageUrl(resId, org) {
    const endpoint = url.parse(config.API);
    let leader = '';
    if (org) {
        leader = '/org/' + org;
    }
    endpoint.pathname = leader + '/manage';
    const manageUrl = url.format(endpoint);
    // TODO: what was this meant to do?
    endpoint.pathname = leader + '/monitor/' + resId;
    return manageUrl;
}
//# sourceMappingURL=format-monitor-response.js.map