"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFeatureFlagSupportedForOrg = void 0;
const request = require("./request");
const snyk = require("."); // TODO(kyegupov): fix import
const config = require("./config");
const common_1 = require("./snyk-test/common");
async function isFeatureFlagSupportedForOrg(featureFlag, org) {
    const response = await request({
        method: 'GET',
        headers: {
            Authorization: `token ${snyk.api}`,
        },
        qs: common_1.assembleQueryString({ org }),
        url: `${config.API}/cli-config/feature-flags/${featureFlag}`,
        gzip: true,
        json: true,
    });
    return response.body;
}
exports.isFeatureFlagSupportedForOrg = isFeatureFlagSupportedForOrg;
//# sourceMappingURL=feature-flags.js.map