"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthFailedError = void 0;
const custom_error_1 = require("./custom-error");
const config = require("../config");
function AuthFailedError(errorMessage = 'Authentication failed. Please check the API token on ' +
    config.ROOT, errorCode = 401) {
    const error = new custom_error_1.CustomError(errorMessage);
    error.code = errorCode;
    error.strCode = 'authfail';
    error.userMessage = errorMessage;
    return error;
}
exports.AuthFailedError = AuthFailedError;
//# sourceMappingURL=authentication-failed-error.js.map