# sol-explore
Traversal functions for solidity-parser generated AST

#Documentation

sol-explore provides Depth-First Traversal of the abstract syntax tree that solidity-parser creates for your solidity code.
You provide the AST and specifiy the callbacks that get called upon entering and leaving a particular node during the traversal.

#Run in Browser
```html
<script src="sol-explore-bundle.js"></script>
```
Then access the object using ```window.SolExplore``` or simply ```SolExplore```

#Install in Node

```bash
npm install --save sol-explore
```

#API

```sol-explorer``` exports a function ```traverse``` and an object ```traversalOptions```. ```traverse``` expects 2 arguments - the first is the AST generated by solidity-parser (or any other parser of your choice which follows a similar Solidity Tree Pattern) and the second is either a function or an object.

If the 2nd argument is simply a function, it is treated as the callback to call when **entering** an un-explored node. If the argument is an object, the object must have 2 properties:

      object.enter = function () {...}  //callback to call when entering an un-explored node
      object.leave = function () {...}  //callback to call when leaving an explored node
      
You may use 2 additional features inside these functions:

      this.stopTraversal () /*OR*/ return solExplorer.traversalOptions.STOP_TRAVERSAL //stop tree traversal immediately
      this.skipNodesBelow () /*OR*/ return solExplorer.traversalOptions.SKIP_NODES_BELOW  //skip the child nodes of the current node

#Example
```js
/*
here, solExplore is the required()d object,
ast is the Abstract Syntax Tree created by solidity-parser
See examples/ directory for complete example with sample solidity code
*/
solExplore.traverse (ast, {
	enter: function (node, parent) {
		console.log ('Entering', node.type);
		if (node.type === 'StructDeclaration') {
			//this.skipNodesBelow ();
			this.stopTraversal ();
			
			//return solExplore.traversalOptions.STOP_TRAVERSAL;
			//return solExplore.traversalOptions.SKIP_NODES_BELOW;
		}
	},
	leave: function (node) {
		console.log ('Leaving', node.type);
	}
});
```

#License
##MIT
