import { TransformOptions, TransformedSource, Transformer } from '@jest/transform/build/types';
import { Config } from '@jest/types';
import { Logger } from 'bs-logger';
import { ConfigSet } from './config/config-set';
import { TsJestGlobalOptions } from './types';
export declare class TsJestTransformer implements Transformer {
    static get lastTransformerId(): number;
    readonly logger: Logger;
    readonly id: number;
    readonly options: TsJestGlobalOptions;
    constructor(baseOptions?: TsJestGlobalOptions);
    configsFor(jestConfig: Config.ProjectConfig | string): ConfigSet;
    process(input: string, filePath: Config.Path, jestConfig: Config.ProjectConfig, transformOptions?: TransformOptions): TransformedSource | string;
    getCacheKey(fileContent: string, filePath: string, jestConfigStr: string, transformOptions?: {
        instrument?: boolean;
        rootDir?: string;
    }): string;
}
