/**
 * Typpy
 * Gets the type of the input value.
 *
 * @name Typpy
 * @function
 * @param {Anything} input The input value.
 * @return {String} The input value type (always lowercase).
 */
function Typpy(input) {

    if (typeof input === "string") {
        return "string";
    }

    if (null === input) {
        return "null";
    }

    if (undefined === input) {
        return "undefined";
    }

    return input.constructor.name.toLowerCase();
}

module.exports = Typpy;
