'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var react = require('react');
var arePassiveEventsSupported = _interopDefault(require('are-passive-events-supported'));
var useLatest = _interopDefault(require('use-latest'));

var isBrowser = typeof document !== 'undefined';

var MOUSEDOWN = 'mousedown';
var TOUCHSTART = 'touchstart';
var events = [MOUSEDOWN, TOUCHSTART];

var getOptions = function getOptions(event) {
  if (event !== TOUCHSTART) {
    return;
  }

  if (arePassiveEventsSupported()) {
    return {
      passive: true
    };
  }
};

function useOnClickOutside(ref, handler) {
  if (!(isBrowser)) {
    return;
  }

  var handlerRef = useLatest(handler);
  react.useEffect(function () {
    if (!handler) {
      return;
    }

    var listener = function listener(event) {
      if (!ref.current || !handlerRef.current || ref.current.contains(event.target)) {
        return;
      }

      handlerRef.current(event);
    };

    events.forEach(function (event) {
      document.addEventListener(event, listener, getOptions(event));
    });
    return function () {
      events.forEach(function (event) {
        document.removeEventListener(event, listener, getOptions(event));
      });
    };
  }, [!handler]);
}

exports.default = useOnClickOutside;
