"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _math = require("math.gl");

var _mathUtils = require("./math-utils");

var _webMercatorUtils = require("./web-mercator-utils");

var _scale = _interopRequireDefault(require("gl-mat4/scale"));

var _translate = _interopRequireDefault(require("gl-mat4/translate"));

var _multiply = _interopRequireDefault(require("gl-mat4/multiply"));

var _invert = _interopRequireDefault(require("gl-mat4/invert"));

var IDENTITY = (0, _mathUtils.createMat4)();

var Viewport = function () {
  function Viewport() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        width = _ref.width,
        height = _ref.height,
        _ref$viewMatrix = _ref.viewMatrix,
        viewMatrix = _ref$viewMatrix === void 0 ? IDENTITY : _ref$viewMatrix,
        _ref$projectionMatrix = _ref.projectionMatrix,
        projectionMatrix = _ref$projectionMatrix === void 0 ? IDENTITY : _ref$projectionMatrix;

    (0, _classCallCheck2.default)(this, Viewport);
    this.width = width || 1;
    this.height = height || 1;
    this.scale = 1;
    this.viewMatrix = viewMatrix;
    this.projectionMatrix = projectionMatrix;
    var vpm = (0, _mathUtils.createMat4)();
    (0, _multiply.default)(vpm, vpm, this.projectionMatrix);
    (0, _multiply.default)(vpm, vpm, this.viewMatrix);
    this.viewProjectionMatrix = vpm;
    var m = (0, _mathUtils.createMat4)();
    (0, _scale.default)(m, m, [this.width / 2, -this.height / 2, 1]);
    (0, _translate.default)(m, m, [1, -1, 0]);
    (0, _multiply.default)(m, m, this.viewProjectionMatrix);
    var mInverse = (0, _invert.default)((0, _mathUtils.createMat4)(), m);

    if (!mInverse) {
      throw new Error('Pixel project matrix not invertible');
    }

    this.pixelProjectionMatrix = m;
    this.pixelUnprojectionMatrix = mInverse;
    this.equals = this.equals.bind(this);
    this.project = this.project.bind(this);
    this.unproject = this.unproject.bind(this);
    this.projectFlat = this.projectFlat.bind(this);
    this.unprojectFlat = this.unprojectFlat.bind(this);
  }

  (0, _createClass2.default)(Viewport, [{
    key: "equals",
    value: function equals(viewport) {
      if (!(viewport instanceof Viewport)) {
        return false;
      }

      return viewport.width === this.width && viewport.height === this.height && (0, _math.equals)(viewport.projectionMatrix, this.projectionMatrix) && (0, _math.equals)(viewport.viewMatrix, this.viewMatrix);
    }
  }, {
    key: "project",
    value: function project(xyz) {
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref2$topLeft = _ref2.topLeft,
          topLeft = _ref2$topLeft === void 0 ? true : _ref2$topLeft;

      var _xyz = (0, _slicedToArray2.default)(xyz, 3),
          x0 = _xyz[0],
          y0 = _xyz[1],
          z0 = _xyz[2];

      var _this$projectFlat = this.projectFlat([x0, y0]),
          _this$projectFlat2 = (0, _slicedToArray2.default)(_this$projectFlat, 2),
          X = _this$projectFlat2[0],
          Y = _this$projectFlat2[1];

      var coord = (0, _webMercatorUtils.worldToPixels)([X, Y, z0], this.pixelProjectionMatrix);

      var _coord = (0, _slicedToArray2.default)(coord, 2),
          x = _coord[0],
          y = _coord[1];

      var y2 = topLeft ? y : this.height - y;
      return xyz.length === 2 ? [x, y2] : [x, y2, coord[2]];
    }
  }, {
    key: "unproject",
    value: function unproject(xyz) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref3$topLeft = _ref3.topLeft,
          topLeft = _ref3$topLeft === void 0 ? true : _ref3$topLeft,
          targetZ = _ref3.targetZ;

      var _xyz2 = (0, _slicedToArray2.default)(xyz, 3),
          x = _xyz2[0],
          y = _xyz2[1],
          z = _xyz2[2];

      var y2 = topLeft ? y : this.height - y;
      var coord = (0, _webMercatorUtils.pixelsToWorld)([x, y2, z], this.pixelUnprojectionMatrix, targetZ);

      var _this$unprojectFlat = this.unprojectFlat(coord),
          _this$unprojectFlat2 = (0, _slicedToArray2.default)(_this$unprojectFlat, 2),
          X = _this$unprojectFlat2[0],
          Y = _this$unprojectFlat2[1];

      if (Number.isFinite(z)) {
        return [X, Y, coord[2]];
      }

      return Number.isFinite(targetZ) ? [X, Y, targetZ] : [X, Y];
    }
  }, {
    key: "projectFlat",
    value: function projectFlat(xyz) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.scale;
      return xyz;
    }
  }, {
    key: "unprojectFlat",
    value: function unprojectFlat(xyz) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.scale;
      return xyz;
    }
  }]);
  return Viewport;
}();

exports.default = Viewport;
//# sourceMappingURL=viewport.js.map