import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { equals } from 'math.gl';
import { createMat4 } from './math-utils';
import { worldToPixels, pixelsToWorld } from './web-mercator-utils';
import mat4_scale from 'gl-mat4/scale';
import mat4_translate from 'gl-mat4/translate';
import mat4_multiply from 'gl-mat4/multiply';
import mat4_invert from 'gl-mat4/invert';
const IDENTITY = createMat4();
export default class Viewport {
  constructor({
    width,
    height,
    viewMatrix = IDENTITY,
    projectionMatrix = IDENTITY
  } = {}) {
    this.width = width || 1;
    this.height = height || 1;
    this.scale = 1;
    this.viewMatrix = viewMatrix;
    this.projectionMatrix = projectionMatrix;
    const vpm = createMat4();
    mat4_multiply(vpm, vpm, this.projectionMatrix);
    mat4_multiply(vpm, vpm, this.viewMatrix);
    this.viewProjectionMatrix = vpm;
    const m = createMat4();
    mat4_scale(m, m, [this.width / 2, -this.height / 2, 1]);
    mat4_translate(m, m, [1, -1, 0]);
    mat4_multiply(m, m, this.viewProjectionMatrix);
    const mInverse = mat4_invert(createMat4(), m);

    if (!mInverse) {
      throw new Error('Pixel project matrix not invertible');
    }

    this.pixelProjectionMatrix = m;
    this.pixelUnprojectionMatrix = mInverse;
    this.equals = this.equals.bind(this);
    this.project = this.project.bind(this);
    this.unproject = this.unproject.bind(this);
    this.projectFlat = this.projectFlat.bind(this);
    this.unprojectFlat = this.unprojectFlat.bind(this);
  }

  equals(viewport) {
    if (!(viewport instanceof Viewport)) {
      return false;
    }

    return viewport.width === this.width && viewport.height === this.height && equals(viewport.projectionMatrix, this.projectionMatrix) && equals(viewport.viewMatrix, this.viewMatrix);
  }

  project(xyz, {
    topLeft = true
  } = {}) {
    const _xyz = _slicedToArray(xyz, 3),
          x0 = _xyz[0],
          y0 = _xyz[1],
          z0 = _xyz[2];

    const _this$projectFlat = this.projectFlat([x0, y0]),
          _this$projectFlat2 = _slicedToArray(_this$projectFlat, 2),
          X = _this$projectFlat2[0],
          Y = _this$projectFlat2[1];

    const coord = worldToPixels([X, Y, z0], this.pixelProjectionMatrix);

    const _coord = _slicedToArray(coord, 2),
          x = _coord[0],
          y = _coord[1];

    const y2 = topLeft ? y : this.height - y;
    return xyz.length === 2 ? [x, y2] : [x, y2, coord[2]];
  }

  unproject(xyz, {
    topLeft = true,
    targetZ
  } = {}) {
    const _xyz2 = _slicedToArray(xyz, 3),
          x = _xyz2[0],
          y = _xyz2[1],
          z = _xyz2[2];

    const y2 = topLeft ? y : this.height - y;
    const coord = pixelsToWorld([x, y2, z], this.pixelUnprojectionMatrix, targetZ);

    const _this$unprojectFlat = this.unprojectFlat(coord),
          _this$unprojectFlat2 = _slicedToArray(_this$unprojectFlat, 2),
          X = _this$unprojectFlat2[0],
          Y = _this$unprojectFlat2[1];

    if (Number.isFinite(z)) {
      return [X, Y, coord[2]];
    }

    return Number.isFinite(targetZ) ? [X, Y, targetZ] : [X, Y];
  }

  projectFlat(xyz, scale = this.scale) {
    return xyz;
  }

  unprojectFlat(xyz, scale = this.scale) {
    return xyz;
  }

}
//# sourceMappingURL=viewport.js.map